import os
import sys
import cli.process_nsys_rep_cli

nsys_path = r"C:\Program Files\NVIDIA Corporation\Nsight Systems 2025.1.0"
input_path = r"D:\src\git\nsys-cpu-stats\test_data"

output_folder = "./viewer/src/data"
output_sqlite_folder = "./output"
output_resolved_folder = "./output"
output_xlsx_folder = "./output"
output_scratch_folder = "./output"

if __name__ == "__main__":
    # Set logger output to stdout
    os.environ["PNR_LOGGER_STDOUT"] = "True"
    # Clear output_folder
    for file in os.listdir(output_folder):
        os.remove(os.path.join(output_folder, file))

    for f in os.listdir(input_path):
        input_file = None
        if f.endswith(".nsys-rep"):
            input_file = os.path.join(input_path, f)

        if input_file:
            print(f"Processing {input_file}")

            # Need to add all of the optional args and set them as None, otherwise there is an issue writing the meta_info df to sql
            cli.process_nsys_rep_cli.process(
                nsys_dir_path=nsys_path,
                input_file=input_file,
                output_path=output_folder,
                output_sqlite_path=output_sqlite_folder,
                output_sqlite_name=f + ".sqlite",
                start_time_sec=None,
                end_time_sec=None)
            break
