/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.bytecode;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.bytecode.PrintExprNodeGen;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;

@GenerateUncached
@GenerateInline(value=false)
public abstract class PrintExprNode
extends PNodeWithContext {
    public abstract void execute(Frame var1, Object var2);

    @Specialization
    void print(VirtualFrame frame, Object object, @Bind Node inliningTarget, @Cached PyObjectLookupAttr lookupAttr, @Cached CallNode callNode) {
        PythonModule sysModule = this.getContext().getSysModule();
        Object displayhook = lookupAttr.execute((Frame)frame, inliningTarget, sysModule, BuiltinNames.T_DISPLAYHOOK);
        if (displayhook == PNone.NO_VALUE) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw PRaiseNode.raiseStatic((Node)this, PythonBuiltinClassType.RuntimeError, ErrorMessages.LOST_SYSDISPLAYHOOK);
        }
        callNode.execute((Frame)frame, displayhook, object);
    }

    @NeverDefault
    public static PrintExprNode create() {
        return PrintExprNodeGen.create();
    }

    public static PrintExprNode getUncached() {
        return PrintExprNodeGen.getUncached();
    }
}

