/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.ImmutableDatabaseProperty;
import schemacrawler.crawl.ImmutableDatabaseUser;
import schemacrawler.crawl.ImmutableJdbcDriverProperty;
import schemacrawler.crawl.ImmutableServerInfoProperty;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableDatabaseInfo;
import schemacrawler.crawl.MutableJdbcDriverInfo;
import schemacrawler.crawl.RetrievalCounts;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.schemacrawler.InformationSchemaKey;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.Query;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import us.fatehi.utility.CollectionsUtility;
import us.fatehi.utility.Utility;
import us.fatehi.utility.UtilityLogger;
import us.fatehi.utility.database.DatabaseUtility;
import us.fatehi.utility.property.Property;
import us.fatehi.utility.string.StringFormat;

final class DatabaseInfoRetriever
extends AbstractRetriever {
    private static final Logger LOGGER = Logger.getLogger(DatabaseInfoRetriever.class.getName());
    private static final List<String> ignoreMethods = List.of("getDatabaseProductName", "getDatabaseProductVersion", "getURL", "getUserName", "getDriverName", "getDriverVersion");

    private static boolean isDatabasePropertiesResultSetMethod(Method method) {
        Class<?> returnType = method.getReturnType();
        return returnType.equals(ResultSet.class) && method.getParameterTypes().length == 0;
    }

    private static boolean isDatabasePropertyListMethod(Method method) {
        Class<?> returnType = method.getReturnType();
        return returnType.equals(String.class) && method.getName().endsWith("s") && method.getParameterTypes().length == 0;
    }

    private static boolean isDatabasePropertyMethod(Method method) {
        Class<?> returnType = method.getReturnType();
        boolean notPropertyMethod = returnType.equals(ResultSet.class) || returnType.equals(Connection.class) || method.getParameterTypes().length > 0;
        return !notPropertyMethod;
    }

    private static ImmutableDatabaseProperty retrieveResultSetTypeProperty(DatabaseMetaData dbMetaData, Method method, int resultSetType, String resultSetTypeName) throws IllegalAccessException, InvocationTargetException {
        String name = method.getName() + "For" + resultSetTypeName + "ResultSets";
        Boolean propertyValue = (Boolean)method.invoke((Object)dbMetaData, resultSetType);
        return new ImmutableDatabaseProperty(name, propertyValue);
    }

    DatabaseInfoRetriever(RetrieverConnection retrieverConnection, MutableCatalog catalog, SchemaCrawlerOptions options) throws SQLException {
        super(retrieverConnection, catalog, options);
    }

    void retrieveAdditionalDatabaseInfo() {
        try (Connection connection = this.getRetrieverConnection().getConnection("additional database information");){
            Method[] methods;
            DatabaseMetaData dbMetaData = connection.getMetaData();
            MutableDatabaseInfo dbInfo = this.catalog.getDatabaseInfo();
            ArrayList<ImmutableDatabaseProperty> dbProperties = new ArrayList<ImmutableDatabaseProperty>();
            for (Method method : methods = DatabaseMetaData.class.getMethods()) {
                try {
                    List valuesList;
                    String methodName = method.getName();
                    if (method.getParameterTypes().length > 0 || ignoreMethods.contains(methodName)) continue;
                    LOGGER.log(Level.FINER, (Supplier<String>)new StringFormat("Retrieving database property using method <%s>", new Object[]{method}));
                    Object methodReturnValue = method.invoke((Object)dbMetaData, new Object[0]);
                    if (DatabaseInfoRetriever.isDatabasePropertyListMethod(method)) {
                        String value = (String)methodReturnValue;
                        valuesList = Arrays.asList(CollectionsUtility.splitList((String)value));
                        Collections.sort(valuesList);
                        dbProperties.add(new ImmutableDatabaseProperty(methodName, List.copyOf(valuesList)));
                        continue;
                    }
                    if (DatabaseInfoRetriever.isDatabasePropertyMethod(method)) {
                        dbProperties.add(new ImmutableDatabaseProperty(methodName, methodReturnValue));
                        continue;
                    }
                    if (!DatabaseInfoRetriever.isDatabasePropertiesResultSetMethod(method)) continue;
                    ResultSet results = (ResultSet)methodReturnValue;
                    valuesList = DatabaseUtility.readResultsVector((ResultSet)results);
                    Collections.sort(valuesList);
                    dbProperties.add(new ImmutableDatabaseProperty(methodName, List.copyOf(valuesList)));
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    LOGGER.log(Level.FINE, e.getCause(), (Supplier<String>)new StringFormat("Could not execute method <%s>", new Object[]{method}));
                }
                catch (AbstractMethodError e) {
                    new UtilityLogger(LOGGER).logSQLFeatureNotSupported((Supplier)new StringFormat("Database metadata method <%s> not supported", new Object[]{method}), (Throwable)e);
                }
                catch (SQLException e) {
                    new UtilityLogger(LOGGER).logPossiblyUnsupportedSQLFeature((Supplier)new StringFormat("SQL exception invoking method <%s>", new Object[]{method}), e);
                }
            }
            Collection<ImmutableDatabaseProperty> resultSetTypesProperties = this.retrieveResultSetTypesProperties(dbMetaData);
            dbProperties.addAll(resultSetTypesProperties);
            dbInfo.addAll(dbProperties);
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Could not obtain additional database information", e);
        }
    }

    void retrieveAdditionalJdbcDriverInfo() {
        MutableJdbcDriverInfo driverInfo = this.catalog.getJdbcDriverInfo();
        if (driverInfo == null) {
            return;
        }
        try (Connection connection = this.getRetrieverConnection().getConnection("additional JDBC driver information");){
            DriverPropertyInfo[] propertyInfo;
            DatabaseMetaData dbMetaData = connection.getMetaData();
            String url = dbMetaData.getURL();
            Driver jdbcDriver = DriverManager.getDriver(dbMetaData.getURL());
            if (jdbcDriver == null) {
                throw new SQLException("No JDBC driver found");
            }
            for (DriverPropertyInfo driverPropertyInfo : propertyInfo = jdbcDriver.getPropertyInfo(url, new Properties())) {
                driverInfo.addJdbcDriverProperty(new ImmutableJdbcDriverProperty(driverPropertyInfo));
            }
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Could not obtain additional JDBC driver information", e);
        }
    }

    void retrieveDatabaseUsers() {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.DATABASE_USERS)) {
            LOGGER.log(Level.INFO, "Not retrieving database users information, since this was not requested");
            LOGGER.log(Level.FINE, "Database users SQL statement was not provided");
            return;
        }
        Query databaseUsersSql = informationSchemaViews.getQuery(InformationSchemaKey.DATABASE_USERS);
        String name = "database users";
        RetrievalCounts retrievalCounts = new RetrievalCounts("database users");
        try (Connection connection = this.getRetrieverConnection().getConnection("database users");
             Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(databaseUsersSql, statement, new HashMap<String, String>());){
            while (results.next()) {
                retrievalCounts.count();
                String username = results.getString("USERNAME");
                if (Utility.isBlank((String)username)) continue;
                LOGGER.log(Level.FINER, (Supplier<String>)new StringFormat("Retrieving database user name: %s", new Object[]{username}));
                ImmutableDatabaseUser databaseUser = new ImmutableDatabaseUser(username);
                databaseUser.addAttributes(results.getAttributes());
                this.catalog.addDatabaseUser(databaseUser);
                retrievalCounts.countIncluded();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve database users", e);
        }
        retrievalCounts.log();
    }

    void retrieveServerInfo() {
        MutableDatabaseInfo dbInfo = this.catalog.getDatabaseInfo();
        if (dbInfo == null) {
            return;
        }
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.SERVER_INFORMATION)) {
            LOGGER.log(Level.INFO, "Not retrieving server information, since this was not requested");
            LOGGER.log(Level.FINE, "Server information SQL statement was not provided");
            return;
        }
        Query serverInfoSql = informationSchemaViews.getQuery(InformationSchemaKey.SERVER_INFORMATION);
        try (Connection connection = this.getRetrieverConnection().getConnection("server information");
             Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(serverInfoSql, statement, new HashMap<String, String>());){
            while (results.next()) {
                String propertyName = results.getString("NAME");
                if (Utility.isBlank((String)propertyName)) continue;
                String propertyValue = results.getString("VALUE");
                String propertyDescription = results.getString("DESCRIPTION");
                LOGGER.log(Level.FINER, (Supplier<String>)new StringFormat("Retrieving server information property: %s=%s", new Object[]{propertyName, propertyValue}));
                ImmutableServerInfoProperty serverInfoProperty = new ImmutableServerInfoProperty(propertyName, propertyValue, propertyDescription);
                dbInfo.addServerInfo((Property)serverInfoProperty);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve server information", e);
        }
    }

    private Collection<ImmutableDatabaseProperty> retrieveResultSetTypesProperties(DatabaseMetaData dbMetaData) {
        String[] resultSetTypesMethods;
        ArrayList<ImmutableDatabaseProperty> dbProperties = new ArrayList<ImmutableDatabaseProperty>();
        for (String methodName : resultSetTypesMethods = new String[]{"deletesAreDetected", "insertsAreDetected", "updatesAreDetected", "othersInsertsAreVisible", "othersDeletesAreVisible", "othersUpdatesAreVisible", "ownDeletesAreVisible", "ownInsertsAreVisible", "ownUpdatesAreVisible", "supportsResultSetType"}) {
            try {
                Method method = DatabaseMetaData.class.getMethod(methodName, Integer.TYPE);
                LOGGER.log(Level.FINER, (Supplier<String>)new StringFormat("Retrieving database property using method <%s>", new Object[]{method}));
                dbProperties.add(DatabaseInfoRetriever.retrieveResultSetTypeProperty(dbMetaData, method, 1003, "TYPE_FORWARD_ONLY"));
                dbProperties.add(DatabaseInfoRetriever.retrieveResultSetTypeProperty(dbMetaData, method, 1004, "TYPE_SCROLL_INSENSITIVE"));
                dbProperties.add(DatabaseInfoRetriever.retrieveResultSetTypeProperty(dbMetaData, method, 1005, "TYPE_SCROLL_SENSITIVE"));
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, e.getCause(), (Supplier<String>)new StringFormat("Could not execute method <%s>", new Object[]{methodName}));
            }
        }
        return dbProperties;
    }
}

