/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.io;

import com.oracle.graal.python.builtins.modules.io.FD;
import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.truffle.api.object.Shape;

public final class PFileIO
extends PythonBuiltinObject {
    private FD fd = null;
    private boolean created = false;
    private boolean readable = false;
    private boolean writable = false;
    private boolean appending = false;
    private int seekable = -1;
    private boolean closefd = true;
    boolean finalizing = false;
    private int blksize = 0;

    public PFileIO(Object cls, Shape instanceShape) {
        super(cls, instanceShape);
    }

    public int getFD() {
        return this.fd != null ? this.fd.getFD() : -1;
    }

    public void setFD(int fd, PythonContext context) {
        assert (this.fd == null) : "'fd' has not been closed!";
        this.fd = this.closefd ? new FD(fd, context) : new FD(fd);
    }

    public void setClosed() {
        if (this.fd != null) {
            if (this.fd.getOwnFD() != null) {
                this.fd.getOwnFD().markReleased();
            }
            this.fd = null;
        }
    }

    public boolean isClosed() {
        return this.fd == null;
    }

    public boolean isCreated() {
        return this.created;
    }

    public void setCreated() {
        this.created = true;
    }

    public boolean isReadable() {
        return this.readable;
    }

    public void setReadable() {
        this.readable = true;
    }

    public boolean isWritable() {
        return this.writable;
    }

    public void setWritable() {
        this.writable = true;
    }

    public boolean isAppending() {
        return this.appending;
    }

    public void setAppending() {
        this.appending = true;
    }

    public int getSeekable() {
        return this.seekable;
    }

    public void setSeekable(int seekable) {
        this.seekable = seekable;
    }

    public boolean isCloseFD() {
        return this.closefd;
    }

    public void setCloseFD(boolean closefd) {
        this.closefd = closefd;
    }

    public boolean isFinalizing() {
        return this.finalizing;
    }

    public void setFinalizing(boolean finalizing) {
        this.finalizing = finalizing;
    }

    public int getBlksize() {
        return this.blksize;
    }

    public void setBlksize(int blksize) {
        this.blksize = blksize;
    }
}

