/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.tools;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.GradleException;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.logging.text.DiagnosticsVisitor;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.nativeplatform.toolchain.internal.ToolType;
import org.gradle.nativeplatform.toolchain.internal.tools.CommandLineToolSearchResult;

public class ToolSearchPath {
    private final Map<String, File> executables = new HashMap<String, File>();
    private final List<File> pathEntries = new ArrayList<File>();
    private final OperatingSystem operatingSystem;

    public ToolSearchPath(OperatingSystem operatingSystem) {
        this.operatingSystem = operatingSystem;
    }

    public List<File> getPath() {
        return this.pathEntries;
    }

    public void setPath(List<File> pathEntries) {
        this.pathEntries.clear();
        this.pathEntries.addAll(pathEntries);
        this.executables.clear();
    }

    public void path(File pathEntry) {
        this.pathEntries.add(pathEntry);
        this.executables.clear();
    }

    public CommandLineToolSearchResult locate(ToolType key, String exeName) {
        File executable = this.executables.get(exeName);
        if (executable == null && (executable = this.findExecutable(this.operatingSystem, exeName)) != null) {
            this.executables.put(exeName, executable);
        }
        return executable == null || !executable.isFile() ? new MissingTool(key, exeName, this.pathEntries) : new FoundTool(executable);
    }

    private File findExecutable(OperatingSystem operatingSystem, String name) {
        List<File> path = this.pathEntries.isEmpty() ? operatingSystem.getPath() : this.pathEntries;
        String exeName = operatingSystem.getExecutableName(name);
        try {
            if (name.contains(File.separator)) {
                return this.maybeResolveFile(operatingSystem, new File(name), new File(exeName));
            }
            for (File pathEntry : path) {
                File resolved = this.maybeResolveFile(operatingSystem, new File(pathEntry, name), new File(pathEntry, exeName));
                if (resolved == null) continue;
                return resolved;
            }
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        return null;
    }

    private File maybeResolveFile(OperatingSystem operatingSystem, File symlinkCandidate, File exeCandidate) throws IOException {
        File symlink;
        if (exeCandidate.isFile()) {
            return exeCandidate;
        }
        if (operatingSystem.isWindows() && (symlink = this.maybeResolveCygwinSymlink(symlinkCandidate)) != null) {
            return symlink;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File maybeResolveCygwinSymlink(File symlink) throws IOException {
        String pathStr;
        if (!symlink.isFile()) {
            return null;
        }
        if (symlink.length() <= 11L) {
            return null;
        }
        try (DataInputStream instr = new DataInputStream(new BufferedInputStream(new FileInputStream(symlink)));){
            byte[] header = new byte[10];
            instr.readFully(header);
            if (!new String(header, "utf-8").equals("!<symlink>")) {
                File file = null;
                return file;
            }
            byte[] pathContent = new byte[(int)symlink.length() - 11];
            instr.readFully(pathContent);
            pathStr = new String(pathContent, "utf-8");
        }
        symlink = new File(symlink.getParentFile(), pathStr);
        if (symlink.isFile()) {
            return symlink.getCanonicalFile();
        }
        return null;
    }

    private static class MissingTool
    implements CommandLineToolSearchResult {
        private final ToolType type;
        private final String exeName;
        private final List<File> path;

        private MissingTool(ToolType type, String exeName, List<File> path) {
            this.type = type;
            this.exeName = exeName;
            this.path = path;
        }

        public void explain(DiagnosticsVisitor visitor) {
            if (this.path.isEmpty()) {
                visitor.node(String.format("Could not find %s '%s' in system path.", this.type.getToolName(), this.exeName));
            } else {
                visitor.node(String.format("Could not find %s '%s'. Searched in", this.type.getToolName(), this.exeName));
                visitor.startChildren();
                for (File location : this.path) {
                    visitor.node(location.toString());
                }
                visitor.endChildren();
            }
        }

        @Override
        public File getTool() {
            TreeFormatter formatter = new TreeFormatter();
            this.explain((DiagnosticsVisitor)formatter);
            throw new GradleException(formatter.toString());
        }

        public boolean isAvailable() {
            return false;
        }
    }

    private static class FoundTool
    implements CommandLineToolSearchResult {
        private final File tool;

        private FoundTool(File tool) {
            this.tool = tool;
        }

        public boolean isAvailable() {
            return true;
        }

        @Override
        public File getTool() {
            return this.tool;
        }

        public void explain(DiagnosticsVisitor visitor) {
        }
    }
}

