/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.io.vavr.collection;

import java.io.Serializable;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.kotlin.io.vavr.collection.Collections;
import org.jetbrains.kotlin.io.vavr.collection.Comparators;
import org.jetbrains.kotlin.io.vavr.collection.Iterator;
import org.jetbrains.kotlin.io.vavr.collection.RedBlackTree;
import org.jetbrains.kotlin.io.vavr.collection.Set;
import org.jetbrains.kotlin.io.vavr.collection.SortedSet;

public final class TreeSet<T>
implements SortedSet<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final RedBlackTree<T> tree;

    TreeSet(RedBlackTree<T> tree) {
        this.tree = tree;
    }

    public static <T> TreeSet<T> empty(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator, "comparator is null");
        return new TreeSet<T>(RedBlackTree.empty(comparator));
    }

    public static <T> TreeSet<T> ofAll(Comparator<? super T> comparator, Iterable<? extends T> values2) {
        Objects.requireNonNull(comparator, "comparator is null");
        Objects.requireNonNull(values2, "values is null");
        if (values2 instanceof TreeSet && ((TreeSet)values2).comparator() == comparator) {
            return (TreeSet)values2;
        }
        return values2.iterator().hasNext() ? new TreeSet<T>(RedBlackTree.ofAll(comparator, values2)) : TreeSet.empty(comparator);
    }

    @Override
    public TreeSet<T> add(T element) {
        return this.contains(element) ? this : new TreeSet<T>(this.tree.insert(element));
    }

    @Override
    public Comparator<T> comparator() {
        return this.tree.comparator();
    }

    @Override
    public boolean contains(T element) {
        return this.tree.contains(element);
    }

    @Override
    public TreeSet<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        TreeSet<T> treeSet = TreeSet.ofAll(this.tree.comparator(), this.iterator().filter(predicate));
        return treeSet.length() == this.length() ? this : treeSet;
    }

    @Override
    public boolean hasDefiniteSize() {
        return true;
    }

    @Override
    public T head() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("head of empty TreeSet");
        }
        return this.tree.min().get();
    }

    @Override
    public TreeSet<T> intersect(Set<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        if (this.isEmpty()) {
            return this;
        }
        if (elements instanceof TreeSet) {
            TreeSet that = (TreeSet)elements;
            return new TreeSet<T>(this.tree.intersection(that.tree));
        }
        return this.retainAll(elements);
    }

    @Override
    public boolean isAsync() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.tree.isEmpty();
    }

    @Override
    public boolean isLazy() {
        return false;
    }

    @Override
    public boolean isTraversableAgain() {
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        return this.tree.iterator();
    }

    @Override
    public T last() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("last of empty TreeSet");
        }
        return this.tree.max().get();
    }

    @Override
    public int length() {
        return this.tree.size();
    }

    public <U> TreeSet<U> map(Comparator<? super U> comparator, Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return TreeSet.ofAll(comparator, this.iterator().map(mapper));
    }

    @Override
    public <U> TreeSet<U> map(Function<? super T, ? extends U> mapper) {
        return this.map(Comparators.naturalComparator(), mapper);
    }

    public TreeSet<T> retainAll(Iterable<? extends T> elements) {
        return Collections.retainAll(this, elements);
    }

    @Override
    public TreeSet<T> tail() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("tail of empty TreeSet");
        }
        return new TreeSet<T>(this.tree.delete(this.tree.min().get()));
    }

    @Override
    public java.util.TreeSet<T> toJavaSet() {
        return this.toJavaSet(ignore -> new java.util.TreeSet<T>(this.comparator()));
    }

    public boolean equals(Object o2) {
        return Collections.equals(this, o2);
    }

    public int hashCode() {
        return Collections.hashUnordered(this);
    }

    @Override
    public String stringPrefix() {
        return "TreeSet";
    }

    @Override
    public String toString() {
        return this.mkString(this.stringPrefix() + "(", ", ", ")");
    }
}

