/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.windows.conpty;

import java.util.List;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\b\n\u0002\b\u0005\b \u0018\u00002\u00020\u0001B\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u000eH\u0002J\b\u0010\u0011\u001a\u00020\u000eH\u0002J\b\u0010\u0012\u001a\u00020\u000fH\u0002J\b\u0010\u0013\u001a\u00020\u0003H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/pty4j/windows/conpty/WindowsVersion;", "", "sysPropOsName", "", "sysPropOsVersion", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "buildNumber", "", "getBuildNumber", "()Ljava/lang/Long;", "buildNumberLazy", "Lkotlin/Lazy;", "isGreaterThanOrEqualTo", "", "", "isWindows", "isWindows11OrNewer", "parseMajorVersion", "toString", "pty4j"})
public abstract class WindowsVersion {
    @Nullable
    private final String sysPropOsName;
    @Nullable
    private final String sysPropOsVersion;
    @NotNull
    private final Lazy<Long> buildNumberLazy;

    public WindowsVersion(@Nullable String sysPropOsName, @Nullable String sysPropOsVersion) {
        this.sysPropOsName = sysPropOsName;
        this.sysPropOsVersion = sysPropOsVersion;
        this.buildNumberLazy = LazyKt.lazy(() -> WindowsVersion.buildNumberLazy$lambda$0(this));
    }

    @Nullable
    protected abstract Long getBuildNumber();

    public final boolean isGreaterThanOrEqualTo(int buildNumber) {
        if (!this.isWindows()) {
            return false;
        }
        if (buildNumber <= 22000 && this.isWindows11OrNewer()) {
            return true;
        }
        Long currentBuildNumber = (Long)this.buildNumberLazy.getValue();
        return currentBuildNumber != null && currentBuildNumber >= (long)buildNumber;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isWindows() {
        if (this.sysPropOsName == null) return false;
        String string = this.sysPropOsName.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        if (!StringsKt.startsWith$default((String)string, (String)"windows", (boolean)false, (int)2, null)) return false;
        return true;
    }

    private final boolean isWindows11OrNewer() {
        if (this.sysPropOsName == null) {
            return false;
        }
        String string = this.sysPropOsName.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        Integer n = StringsKt.toIntOrNull((String)StringsKt.removePrefix((String)string, (CharSequence)"windows "));
        int nameVersion = n != null ? n : -1;
        int version = Math.max(nameVersion, this.parseMajorVersion());
        return version >= 11;
    }

    private final int parseMajorVersion() {
        String[] stringArray;
        List versions;
        Object object;
        String string = this.sysPropOsVersion;
        if (string == null) {
            string = "";
        }
        return (object = (String)CollectionsKt.getOrNull((List)(versions = StringsKt.split$default((CharSequence)string, (String[])(stringArray = new String[]{"."}), (boolean)false, (int)2, (int)2, null)), (int)0)) != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : -1;
    }

    @NotNull
    public String toString() {
        String buildNumberStr = this.buildNumberLazy.isInitialized() ? String.valueOf(this.buildNumberLazy.getValue()) : "N/A";
        return "(os.name: " + this.sysPropOsName + ", os.version: " + this.sysPropOsVersion + ", buildNumber: " + buildNumberStr + ")";
    }

    private static final Long buildNumberLazy$lambda$0(WindowsVersion this$0) {
        return this$0.getBuildNumber();
    }
}

