/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion;

import com.intellij.codeInsight.daemon.impl.actions.AddImportAction;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupActionProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.completion.KotlinIdeaCompletionBundle;
import org.jetbrains.kotlin.idea.core.completion.DescriptorBasedDeclarationLookupObject;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0006\b\u0000\u0012\u00020\f0\u000bH\u0016J(\u0010\r\u001a\u00020\u00052\u000e\u0010\n\u001a\n\u0012\u0006\b\u0000\u0012\u00020\f0\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/completion/KotlinExcludeFromCompletionLookupActionProvider;", "Lcom/intellij/codeInsight/lookup/LookupActionProvider;", "<init>", "()V", "fillActions", "", "element", "Lcom/intellij/codeInsight/lookup/LookupElement;", "lookup", "Lcom/intellij/codeInsight/lookup/Lookup;", "consumer", "Lcom/intellij/util/Consumer;", "Lcom/intellij/codeInsight/lookup/LookupElementAction;", "addExcludes", "project", "Lcom/intellij/openapi/project/Project;", "fqName", "", "ExcludeFromCompletionAction", "kotlin.completion.impl.k1"})
public final class KotlinExcludeFromCompletionLookupActionProvider
implements LookupActionProvider {
    public void fillActions(@NotNull LookupElement element, @NotNull Lookup lookup, @NotNull Consumer<? super LookupElementAction> consumer) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Object object = element.getObject();
        DescriptorBasedDeclarationLookupObject descriptorBasedDeclarationLookupObject = object instanceof DescriptorBasedDeclarationLookupObject ? (DescriptorBasedDeclarationLookupObject)object : null;
        if (descriptorBasedDeclarationLookupObject == null) {
            return;
        }
        DescriptorBasedDeclarationLookupObject lookupObject = descriptorBasedDeclarationLookupObject;
        PsiFile psiFile = lookup.getPsiFile();
        if (psiFile == null || (psiFile = psiFile.getProject()) == null) {
            return;
        }
        PsiFile project = psiFile;
        object = lookupObject.getImportableFqName();
        if (object != null) {
            Object it = object;
            boolean bl = false;
            this.addExcludes(consumer, (Project)project, it.asString());
            return;
        }
    }

    private final void addExcludes(Consumer<? super LookupElementAction> consumer, Project project, String fqName2) {
        for (String s : AddImportAction.getAllExcludableStrings((String)fqName2)) {
            Intrinsics.checkNotNull((Object)s);
            consumer.consume((Object)new ExcludeFromCompletionAction(project, s));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/completion/KotlinExcludeFromCompletionLookupActionProvider$ExcludeFromCompletionAction;", "Lcom/intellij/codeInsight/lookup/LookupElementAction;", "project", "Lcom/intellij/openapi/project/Project;", "exclude", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "performLookupAction", "Lcom/intellij/codeInsight/lookup/LookupElementAction$Result;", "kotlin.completion.impl.k1"})
    private static final class ExcludeFromCompletionAction
    extends LookupElementAction {
        @NotNull
        private final Project project;
        @NotNull
        private final String exclude;

        public ExcludeFromCompletionAction(@NotNull Project project, @NotNull String exclude) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)exclude, (String)"exclude");
            Object[] objectArray = new Object[]{exclude};
            super(null, KotlinIdeaCompletionBundle.message("exclude.0.from.completion", objectArray));
            this.project = project;
            this.exclude = exclude;
        }

        @NotNull
        public LookupElementAction.Result performLookupAction() {
            AddImportAction.excludeFromImport((Project)this.project, (String)this.exclude);
            LookupElementAction.Result result2 = LookupElementAction.Result.HIDE_LOOKUP;
            Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"HIDE_LOOKUP");
            return result2;
        }
    }
}

