/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PlainPrefixMatcher;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.completion.BasicLookupElementFactory;
import org.jetbrains.kotlin.idea.completion.CompletionUtilsNoResolveKt;
import org.jetbrains.kotlin.idea.completion.InsertHandlerProvider;
import org.jetbrains.kotlin.idea.core.ExpectedInfo;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.util.CallType;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u0014\u0010\u0004\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R5\u0010\b\u001a&\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n \u000b*\u0012\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0018\u00010\t0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/completion/PackageDirectiveCompletion;", "", "<init>", "()V", "DUMMY_IDENTIFIER", "", "getDUMMY_IDENTIFIER", "()Ljava/lang/String;", "ACTIVATION_PATTERN", "Lcom/intellij/patterns/PsiElementPattern$Capture;", "Lcom/intellij/psi/PsiElement;", "kotlin.jvm.PlatformType", "getACTIVATION_PATTERN", "()Lcom/intellij/patterns/PsiElementPattern$Capture;", "perform", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "kotlin.completion.impl.k1"})
public final class PackageDirectiveCompletion {
    @NotNull
    public static final PackageDirectiveCompletion INSTANCE = new PackageDirectiveCompletion();
    @NotNull
    private static final String DUMMY_IDENTIFIER = "___package___";
    private static final PsiElementPattern.Capture<PsiElement> ACTIVATION_PATTERN = (PsiElementPattern.Capture)PlatformPatterns.psiElement().inside(KtPackageDirective.class);

    private PackageDirectiveCompletion() {
    }

    @NotNull
    public final String getDUMMY_IDENTIFIER() {
        return DUMMY_IDENTIFIER;
    }

    public final PsiElementPattern.Capture<PsiElement> getACTIVATION_PATTERN() {
        return ACTIVATION_PATTERN;
    }

    public final boolean perform(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet result2) {
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        PsiElement psiElement = parameters2.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPosition(...)");
        PsiElement position = psiElement;
        if (!ACTIVATION_PATTERN.accepts((Object)position)) {
            return false;
        }
        PsiFile psiFile = position.getContainingFile();
        Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        KtFile file = (KtFile)psiFile;
        PsiElement psiElement2 = file.findElementAt(parameters2.getOffset());
        PsiElement psiElement3 = psiElement2 != null ? psiElement2.getParent() : null;
        KtSimpleNameExpression ktSimpleNameExpression = psiElement3 instanceof KtSimpleNameExpression ? (KtSimpleNameExpression)psiElement3 : null;
        if (ktSimpleNameExpression == null) {
            return false;
        }
        KtSimpleNameExpression expression = ktSimpleNameExpression;
        int prefixLength = parameters2.getOffset() - expression.getTextOffset();
        String string = expression.getText();
        Intrinsics.checkNotNull((Object)string);
        String prefix2 = string;
        String string2 = prefix2.substring(0, prefixLength);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        PlainPrefixMatcher prefixMatcher = new PlainPrefixMatcher(string2);
        CompletionResultSet completionResultSet = result2.withPrefixMatcher((PrefixMatcher)prefixMatcher);
        Intrinsics.checkNotNullExpressionValue((Object)completionResultSet, (String)"withPrefixMatcher(...)");
        CompletionResultSet resultSet = completionResultSet;
        ResolutionFacade resolutionFacade = ResolutionUtils.getResolutionFacade((KtElement)expression);
        MemberScope packageMemberScope = resolutionFacade.getModuleDescriptor().getPackage(file.getPackageFqName().parent()).getMemberScope();
        Collection variants = packageMemberScope.getContributedDescriptors(DescriptorKindFilter.PACKAGES, CompletionUtilsNoResolveKt.asNameFilter((PrefixMatcher)prefixMatcher));
        Project project = resolutionFacade.getProject();
        CallType callType = CallType.PACKAGE_DIRECTIVE.INSTANCE;
        Editor editor = parameters2.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        BasicLookupElementFactory lookupElementFactory = new BasicLookupElementFactory(project, new InsertHandlerProvider(callType, editor, (Function0<? extends Collection<ExpectedInfo>>)((Function0)PackageDirectiveCompletion::perform$lambda$0)));
        for (DeclarationDescriptor variant : variants) {
            LookupElement lookupElement2 = BasicLookupElementFactory.createLookupElement$default(lookupElementFactory, variant, false, false, false, 14, null);
            String string3 = lookupElement2.getLookupString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getLookupString(...)");
            if (StringsKt.contains$default((CharSequence)string3, (CharSequence)DUMMY_IDENTIFIER, (boolean)false, (int)2, null)) continue;
            resultSet.addElement(lookupElement2);
        }
        return true;
    }

    private static final Collection perform$lambda$0() {
        return CollectionsKt.emptyList();
    }
}

