/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.stepping.filter;

import com.sun.jdi.Location;
import com.sun.jdi.Method;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.idea.debugger.base.util.KotlinDebuggerConstants;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\tH\u0000\u001a \u0010\u0007\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0000\u001a-\u0010\u000e\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u000f2\u0006\u0010\u0006\u001a\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"matchesDefaultMethodSignature", "", "defaultType", "Lorg/jetbrains/org/objectweb/asm/Type;", "actualType", "possiblyConvertedToStatic", "isConstructor", "isSyntheticDefaultMethodPossiblyConvertedToStatic", "location", "Lcom/sun/jdi/Location;", "isStatic", "signature", "", "typeSignature", "matchesDefaultSignature", "", "defaultArgTypes", "([Lorg/jetbrains/org/objectweb/asm/Type;[Lorg/jetbrains/org/objectweb/asm/Type;Z)Z", "kotlin.jvm-debugger.core"})
@SourceDebugExtension(value={"SMAP\nKotlinStepOverParamDefaultImplsMethodFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinStepOverParamDefaultImplsMethodFilter.kt\norg/jetbrains/kotlin/idea/debugger/core/stepping/filter/KotlinStepOverParamDefaultImplsMethodFilterKt\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n37#2:100\n36#2,3:101\n1740#3,3:104\n1740#3,3:107\n*S KotlinDebug\n*F\n+ 1 KotlinStepOverParamDefaultImplsMethodFilter.kt\norg/jetbrains/kotlin/idea/debugger/core/stepping/filter/KotlinStepOverParamDefaultImplsMethodFilterKt\n*L\n74#1:100\n74#1:101,3\n96#1:104,3\n97#1:107,3\n*E\n"})
public final class KotlinStepOverParamDefaultImplsMethodFilterKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean matchesDefaultMethodSignature(@NotNull Type defaultType, @NotNull Type actualType, boolean possiblyConvertedToStatic, boolean isConstructor) {
        Intrinsics.checkNotNullParameter((Object)defaultType, (String)"defaultType");
        Intrinsics.checkNotNullParameter((Object)actualType, (String)"actualType");
        Object[] defaultArgTypes = defaultType.getArgumentTypes();
        Type[] actualArgTypes = actualType.getArgumentTypes();
        Intrinsics.checkNotNull((Object)actualArgTypes);
        Intrinsics.checkNotNull((Object)defaultArgTypes);
        if (KotlinStepOverParamDefaultImplsMethodFilterKt.matchesDefaultSignature(actualArgTypes, (Type[])defaultArgTypes, isConstructor)) return true;
        if (!possiblyConvertedToStatic) return false;
        Collection $this$toTypedArray$iv = ArraysKt.drop((Object[])defaultArgTypes, (int)1);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        if (!KotlinStepOverParamDefaultImplsMethodFilterKt.matchesDefaultSignature(actualArgTypes, thisCollection$iv.toArray(new Type[0]), isConstructor)) return false;
        return true;
    }

    public static final boolean isSyntheticDefaultMethodPossiblyConvertedToStatic(@NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Method method = SafeUtilKt.safeMethod(location);
        if (method == null) {
            return false;
        }
        Method method2 = method;
        boolean bl = method2.isStatic();
        String string = method2.signature();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"signature(...)");
        String string2 = location.declaringType().signature();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"signature(...)");
        return KotlinStepOverParamDefaultImplsMethodFilterKt.isSyntheticDefaultMethodPossiblyConvertedToStatic(bl, string, string2);
    }

    public static final boolean isSyntheticDefaultMethodPossiblyConvertedToStatic(boolean isStatic, @NotNull String signature, @NotNull String typeSignature) {
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        Intrinsics.checkNotNullParameter((Object)typeSignature, (String)"typeSignature");
        return isStatic && StringsKt.startsWith$default((String)signature, (String)("(" + typeSignature), (boolean)false, (int)2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean matchesDefaultSignature(Type[] $this$matchesDefaultSignature, Type[] defaultArgTypes, boolean isConstructor) {
        boolean bl;
        boolean bl2;
        String lastArgumentType = isConstructor ? JvmFileClassUtilKt.getInternalNameWithoutInnerClasses((FqName)KotlinDebuggerConstants.INSTANCE.getDEFAULT_CONSTRUCTOR_MARKER_FQ_NAME()) : "java/lang/Object";
        if ($this$matchesDefaultSignature.length >= defaultArgTypes.length) return false;
        if (!Intrinsics.areEqual((Object)((Type)ArraysKt.last((Object[])defaultArgTypes)).getInternalName(), (Object)lastArgumentType)) return false;
        Iterable $this$all$iv = ArraysKt.zip((Object[])$this$matchesDefaultSignature, (Object[])defaultArgTypes);
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            bl2 = true;
        } else {
            for (Object element$iv : $this$all$iv) {
                Type defaultType;
                Pair pair = (Pair)element$iv;
                boolean bl3 = false;
                Type actualType = (Type)pair.component1();
                if (Intrinsics.areEqual((Object)actualType, (Object)(defaultType = (Type)pair.component2()))) continue;
                return false;
            }
            bl2 = true;
        }
        if (!bl2) return false;
        $this$all$iv = ArraysKt.slice((Object[])defaultArgTypes, (IntRange)RangesKt.until((int)$this$matchesDefaultSignature.length, (int)(defaultArgTypes.length - 1)));
        $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            Object element$iv;
            if (!iterator2.hasNext()) return true;
            element$iv = iterator2.next();
            Type it = (Type)element$iv;
            boolean bl4 = false;
            if (it.getSort() != 5) return false;
            bl = true;
        } while (bl);
        return false;
    }
}

