﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/customer-profiles/CustomerProfiles_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace CustomerProfiles
{
namespace Model
{

  /**
   * <p>A ProfileObject in a list of ProfileObjects.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListProfileObjectsItem">AWS
   * API Reference</a></p>
   */
  class ListProfileObjectsItem
  {
  public:
    AWS_CUSTOMERPROFILES_API ListProfileObjectsItem() = default;
    AWS_CUSTOMERPROFILES_API ListProfileObjectsItem(Aws::Utils::Json::JsonView jsonValue);
    AWS_CUSTOMERPROFILES_API ListProfileObjectsItem& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_CUSTOMERPROFILES_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>Specifies the kind of object being added to a profile, such as
     * "Salesforce-Account."</p>
     */
    inline const Aws::String& GetObjectTypeName() const { return m_objectTypeName; }
    inline bool ObjectTypeNameHasBeenSet() const { return m_objectTypeNameHasBeenSet; }
    template<typename ObjectTypeNameT = Aws::String>
    void SetObjectTypeName(ObjectTypeNameT&& value) { m_objectTypeNameHasBeenSet = true; m_objectTypeName = std::forward<ObjectTypeNameT>(value); }
    template<typename ObjectTypeNameT = Aws::String>
    ListProfileObjectsItem& WithObjectTypeName(ObjectTypeNameT&& value) { SetObjectTypeName(std::forward<ObjectTypeNameT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The unique identifier of the ProfileObject generated by the service.</p>
     */
    inline const Aws::String& GetProfileObjectUniqueKey() const { return m_profileObjectUniqueKey; }
    inline bool ProfileObjectUniqueKeyHasBeenSet() const { return m_profileObjectUniqueKeyHasBeenSet; }
    template<typename ProfileObjectUniqueKeyT = Aws::String>
    void SetProfileObjectUniqueKey(ProfileObjectUniqueKeyT&& value) { m_profileObjectUniqueKeyHasBeenSet = true; m_profileObjectUniqueKey = std::forward<ProfileObjectUniqueKeyT>(value); }
    template<typename ProfileObjectUniqueKeyT = Aws::String>
    ListProfileObjectsItem& WithProfileObjectUniqueKey(ProfileObjectUniqueKeyT&& value) { SetProfileObjectUniqueKey(std::forward<ProfileObjectUniqueKeyT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>A JSON representation of a ProfileObject that belongs to a profile.</p>
     */
    inline const Aws::String& GetObject() const { return m_object; }
    inline bool ObjectHasBeenSet() const { return m_objectHasBeenSet; }
    template<typename ObjectT = Aws::String>
    void SetObject(ObjectT&& value) { m_objectHasBeenSet = true; m_object = std::forward<ObjectT>(value); }
    template<typename ObjectT = Aws::String>
    ListProfileObjectsItem& WithObject(ObjectT&& value) { SetObject(std::forward<ObjectT>(value)); return *this;}
    ///@}
  private:

    Aws::String m_objectTypeName;
    bool m_objectTypeNameHasBeenSet = false;

    Aws::String m_profileObjectUniqueKey;
    bool m_profileObjectUniqueKeyHasBeenSet = false;

    Aws::String m_object;
    bool m_objectHasBeenSet = false;
  };

} // namespace Model
} // namespace CustomerProfiles
} // namespace Aws
