/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css;

import io.sf.carte.doc.DOMInvalidAccessException;
import io.sf.carte.doc.DOMSyntaxException;
import io.sf.carte.doc.style.css.CSSComputedProperties;
import io.sf.carte.doc.style.css.CSSFontFaceRule;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.nsac.SelectorList;
import org.w3c.dom.DOMException;

public interface StyleDatabase {
    public CSSTypedValue getInitialColor();

    public void setInitialColor(String var1);

    public String getDefaultGenericFontFamily(String var1);

    default public String getDefaultGenericFontFamily() {
        return this.getDefaultGenericFontFamily("serif");
    }

    public String getUsedFontFamily(CSSComputedProperties var1);

    default public float getFontSizeFromIdentifier(String familyName, String fontSizeIdentifier) throws DOMException {
        float sz;
        float factor = Math.max(0.9f, this.getDeviceWidth() / 595.0f);
        if (fontSizeIdentifier.equals("xx-small")) {
            sz = 8.0f * factor;
        } else if (fontSizeIdentifier.equals("x-small")) {
            sz = 9.0f * factor;
        } else if (fontSizeIdentifier.equals("small")) {
            sz = 10.0f * factor;
        } else if (fontSizeIdentifier.equals("medium")) {
            sz = 12.0f * factor;
        } else if (fontSizeIdentifier.equals("large")) {
            sz = 14.0f * factor;
        } else if (fontSizeIdentifier.equals("x-large")) {
            sz = 18.0f * factor;
        } else if (fontSizeIdentifier.equals("xx-large")) {
            sz = 24.0f * factor;
        } else {
            throw new DOMInvalidAccessException("Unknown size identifier: " + fontSizeIdentifier);
        }
        return sz;
    }

    default public String getSystemFontDeclaration(String systemFontName) {
        return null;
    }

    public boolean isFontFaceName(String var1);

    public void loadFontFaceRule(CSSFontFaceRule var1);

    default public short getNaturalUnit() {
        return 3;
    }

    default public float getExSizeInPt(String familyName, float size) {
        return Math.round(0.5f * size);
    }

    @Deprecated
    default public float getWidthSize(String widthIdentifier, float fontSize) throws DOMException {
        if ("thin".equalsIgnoreCase(widthIdentifier)) {
            return 0.75f;
        }
        if ("thick".equalsIgnoreCase(widthIdentifier)) {
            return 3.75f;
        }
        if ("medium".equalsIgnoreCase(widthIdentifier)) {
            return 2.25f;
        }
        throw new DOMSyntaxException("Unknown identifier " + widthIdentifier);
    }

    public int getColorDepth();

    public float getDeviceHeight();

    public float getDeviceWidth();

    default public CSSValue getEnvValue(String envVarName) {
        return null;
    }

    default public boolean supports(SelectorList selectors) {
        return true;
    }

    default public boolean supports(String property, LexicalUnit value) {
        return false;
    }

    @Deprecated(forRemoval=true)
    default public boolean supports(String property, CSSValue value) {
        return false;
    }
}

