/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.groovy;

import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileFilters;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.groovy.compiler.rt.OutputItem;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.incremental.Builder;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.groovy.GroovyBuilder;
import org.jetbrains.jps.incremental.groovy.JpsGroovycRunner;

class CompilingGroovycRunner
extends JpsGroovycRunner<JavaSourceRootDescriptor, ModuleBuildTarget> {
    CompilingGroovycRunner(boolean forStubs) {
        super(forStubs);
    }

    @Override
    protected Set<ModuleBuildTarget> getTargets(ModuleChunk chunk) {
        return chunk.getTargets();
    }

    @Override
    protected Map<ModuleBuildTarget, String> getCanonicalOutputs(CompileContext context, ModuleChunk chunk, Builder builder) {
        return GroovyBuilder.getCanonicalModuleOutputs(context, chunk, builder);
    }

    @Override
    protected JavaSourceRootDescriptor findRoot(CompileContext context, File srcFile) {
        return context.getProjectDescriptor().getBuildRootIndex().findJavaRootDescriptor(context, srcFile);
    }

    @Override
    protected void stubsGenerated(CompileContext context, Map<ModuleBuildTarget, String> generationOutputs, MultiMap<ModuleBuildTarget, OutputItem> compiled) {
        CompilingGroovycRunner.addStubRootsToJavacSourcePath(context, generationOutputs);
        CompilingGroovycRunner.rememberStubSources(context, compiled);
    }

    private static void addStubRootsToJavacSourcePath(CompileContext context, Map<ModuleBuildTarget, String> generationOutputs) {
        BuildRootIndex rootsIndex = context.getProjectDescriptor().getBuildRootIndex();
        for (ModuleBuildTarget target : generationOutputs.keySet()) {
            File root = new File(generationOutputs.get(target));
            rootsIndex.associateTempRoot(context, (BuildTarget)target, (BuildRootDescriptor)JavaSourceRootDescriptor.createJavaSourceRootDescriptor((File)root, (ModuleBuildTarget)target, (boolean)true, (boolean)true, (String)"", Set.of(), (FileFilter)FileFilters.EVERYTHING));
        }
    }

    private static void rememberStubSources(CompileContext context, MultiMap<ModuleBuildTarget, OutputItem> compiled) {
        HashMap<String, String> stubToSrc = (HashMap<String, String>)GroovyBuilder.STUB_TO_SRC.get((UserDataHolder)context);
        if (stubToSrc == null) {
            stubToSrc = new HashMap<String, String>();
            GroovyBuilder.STUB_TO_SRC.set((UserDataHolder)context, stubToSrc);
        }
        for (OutputItem item : compiled.values()) {
            stubToSrc.put(FileUtilRt.toSystemIndependentName((String)item.outputPath), item.sourcePath);
        }
    }

    @Override
    protected Map<ModuleBuildTarget, String> getGenerationOutputs(CompileContext context, ModuleChunk chunk, Map<ModuleBuildTarget, String> finalOutputs) throws IOException {
        if (!this.myForStubs) {
            return super.getGenerationOutputs(context, chunk, finalOutputs);
        }
        HashMap<ModuleBuildTarget, String> generationOutputs = new HashMap<ModuleBuildTarget, String>();
        Path commonRoot = GroovyBuilder.getStubRoot(context);
        for (ModuleBuildTarget target : chunk.getTargets()) {
            File targetRoot = commonRoot.resolve(target.getModule().getName() + File.separator + target.getTargetType().getTypeId()).toFile();
            if (targetRoot.exists() && !FileUtil.deleteWithRenaming((File)targetRoot)) {
                throw new IOException("External build cannot clean " + targetRoot.getPath());
            }
            if (!targetRoot.mkdirs()) {
                throw new IOException("External build cannot create " + targetRoot.getPath());
            }
            generationOutputs.put(target, targetRoot.getPath());
        }
        return generationOutputs;
    }
}

