/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.typeEnhancers;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ConversionResult;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrTypeConverter;
import org.jetbrains.plugins.groovy.lang.psi.util.CompileStaticUtil;
import org.jetbrains.plugins.groovy.lang.typing.EmptyListLiteralType;

public final class GrContainerTypeConverter
extends GrTypeConverter {
    @Override
    @Nullable
    public ConversionResult isConvertible(@NotNull PsiType targetType, @NotNull PsiType actualType, @NotNull GrTypeConverter.Position position, @NotNull GroovyPsiElement context) {
        if (targetType == null) {
            GrContainerTypeConverter.$$$reportNull$$$0(0);
        }
        if (actualType == null) {
            GrContainerTypeConverter.$$$reportNull$$$0(1);
        }
        if (position == null) {
            GrContainerTypeConverter.$$$reportNull$$$0(2);
        }
        if (context == null) {
            GrContainerTypeConverter.$$$reportNull$$$0(3);
        }
        if (position == GrTypeConverter.Position.ASSIGNMENT && TypesUtil.resolvesTo(targetType, "java.util.Set") && actualType instanceof EmptyListLiteralType) {
            return ConversionResult.OK;
        }
        if (CompileStaticUtil.isCompileStatic(context)) {
            return GrContainerTypeConverter.isCSConvertible(targetType, actualType, context);
        }
        if (!GrContainerTypeConverter.isCollectionOrArray(targetType) || !GrContainerTypeConverter.isCollectionOrArray(actualType)) {
            return null;
        }
        PsiType lComponentType = GrContainerTypeConverter.extractComponentType(targetType);
        PsiType rComponentType = GrContainerTypeConverter.extractComponentType(actualType);
        if (lComponentType == null || rComponentType == null) {
            return ConversionResult.OK;
        }
        if (TypesUtil.isAssignableByParameter(lComponentType, rComponentType, context)) {
            return ConversionResult.OK;
        }
        return null;
    }

    @Nullable
    private static ConversionResult isCSConvertible(@NotNull PsiType targetType, @NotNull PsiType actualType, @NotNull GroovyPsiElement context) {
        if (targetType == null) {
            GrContainerTypeConverter.$$$reportNull$$$0(4);
        }
        if (actualType == null) {
            GrContainerTypeConverter.$$$reportNull$$$0(5);
        }
        if (context == null) {
            GrContainerTypeConverter.$$$reportNull$$$0(6);
        }
        if (targetType instanceof PsiArrayType && actualType instanceof PsiArrayType) {
            if (((PsiArrayType)targetType).getComponentType() instanceof PsiPrimitiveType != ((PsiArrayType)actualType).getComponentType() instanceof PsiPrimitiveType) {
                return null;
            }
            return TypesUtil.isAssignableByParameter(((PsiArrayType)targetType).getComponentType(), ((PsiArrayType)actualType).getComponentType(), context) ? ConversionResult.OK : ConversionResult.ERROR;
        }
        return null;
    }

    @Override
    public boolean isApplicableTo(@NotNull GrTypeConverter.Position position) {
        if (position == null) {
            GrContainerTypeConverter.$$$reportNull$$$0(7);
        }
        return position != GrTypeConverter.Position.METHOD_PARAMETER;
    }

    @Nullable
    private static PsiType extractComponentType(PsiType type) {
        if (type instanceof PsiArrayType) {
            return ((PsiArrayType)type).getComponentType();
        }
        return PsiUtil.substituteTypeParameter((PsiType)type, (String)"java.util.Collection", (int)0, (boolean)false);
    }

    private static boolean isCollectionOrArray(PsiType type) {
        return type instanceof PsiArrayType || InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.Collection");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetType";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualType";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/GrContainerTypeConverter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isConvertible";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isCSConvertible";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicableTo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

