/*
 * Decompiled with CFR 0.152.
 */
package org.groovy.debug.hotswap;

import groovyResetJarjarAsm.ClassAdapter;
import groovyResetJarjarAsm.ClassReader;
import groovyResetJarjarAsm.ClassWriter;
import groovyResetJarjarAsm.FieldVisitor;
import groovyResetJarjarAsm.MethodAdapter;
import groovyResetJarjarAsm.MethodVisitor;
import groovyResetJarjarAsm.Type;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Field;
import java.security.ProtectionDomain;

public class ResetAgent {
    private static final String timeStampFieldStart = "__timeStamp__239_neverHappen";
    private static final byte[] timeStampFieldStartBytes = new byte["__timeStamp__239_neverHappen".length()];
    private static boolean initialized;

    public static void premain(String string, Instrumentation instrumentation) {
        if (initialized) {
            return;
        }
        initialized = true;
        instrumentation.addTransformer(new ClassFileTransformer(){

            @Override
            public byte[] transform(ClassLoader classLoader, String string, Class<?> clazz, ProtectionDomain protectionDomain, byte[] byArray) throws IllegalClassFormatException {
                try {
                    if (string == null || string.indexOf(36) >= 0) {
                        return null;
                    }
                    if (clazz != null) {
                        Field field = clazz.getDeclaredField("$callSiteArray");
                        field.setAccessible(true);
                        field.set(null, null);
                    }
                    return ResetAgent.removeTimestampField(byArray);
                }
                catch (Throwable throwable) {
                    return null;
                }
            }
        });
    }

    private static boolean matches(byte[] byArray, byte[] byArray2, int n) {
        for (int i = 1; i < byArray2.length; ++i) {
            if (byArray[n + i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    private static boolean containsSubArray(byte[] byArray, byte[] byArray2) {
        int n = byArray.length - byArray2.length;
        for (int i = 0; i < n; ++i) {
            if (byArray[i] != byArray2[0] || !ResetAgent.matches(byArray, byArray2, i)) continue;
            return true;
        }
        return false;
    }

    private static byte[] removeTimestampField(byte[] byArray) {
        if (!ResetAgent.containsSubArray(byArray, timeStampFieldStartBytes)) {
            return null;
        }
        boolean[] blArray = new boolean[]{false};
        ClassWriter classWriter = new ClassWriter(0);
        new ClassReader(byArray).accept(new TimestampFieldRemover(classWriter, blArray), 0);
        if (blArray[0]) {
            return classWriter.toByteArray();
        }
        return null;
    }

    static {
        for (int i = 0; i < timeStampFieldStart.length(); ++i) {
            ResetAgent.timeStampFieldStartBytes[i] = (byte)timeStampFieldStart.charAt(i);
        }
    }

    private static class TimestampFieldRemover
    extends ClassAdapter {
        private final boolean[] changed;

        public TimestampFieldRemover(ClassWriter classWriter, boolean[] blArray) {
            super(classWriter);
            this.changed = blArray;
        }

        public FieldVisitor visitField(int n, String string, String string2, String string3, Object object) {
            if (string.startsWith(ResetAgent.timeStampFieldStart)) {
                this.changed[0] = true;
                return null;
            }
            return super.visitField(n, string, string2, string3, object);
        }

        public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
            MethodVisitor methodVisitor = super.visitMethod(n, string, string2, string3, stringArray);
            if ("<clinit>".equals(string)) {
                return new MethodAdapter(methodVisitor){

                    public void visitFieldInsn(int n, String string, String string2, String string3) {
                        if (string2.startsWith(ResetAgent.timeStampFieldStart) && n == 179) {
                            this.visitInsn(Type.LONG_TYPE.getDescriptor().equals(string3) ? 88 : 87);
                        } else {
                            super.visitFieldInsn(n, string, string2, string3);
                        }
                    }
                };
            }
            return methodVisitor;
        }
    }
}

