/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.api;

import com.intellij.collaboration.messages.CollaborationToolsBundle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\u0018\u00002\u00060\u0001j\u0002`\u0002B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000e\u001a\u00020\u0004H\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000f"}, d2={"Lcom/intellij/collaboration/api/HttpStatusErrorException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "requestName", "", "statusCode", "", "body", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getStatusCode", "()I", "getBody", "()Ljava/lang/String;", "getLocalizedMessage", "intellij.platform.collaborationTools"})
public final class HttpStatusErrorException
extends RuntimeException {
    @NotNull
    private final String requestName;
    private final int statusCode;
    @Nullable
    private final String body;

    public HttpStatusErrorException(@NotNull String requestName, int statusCode, @Nullable String body) {
        Intrinsics.checkNotNullParameter((Object)requestName, (String)"requestName");
        super("HTTP Request " + requestName + " failed with status code " + statusCode + " and response body: " + body);
        this.requestName = requestName;
        this.statusCode = statusCode;
        this.body = body;
    }

    public final int getStatusCode() {
        return this.statusCode;
    }

    @Nullable
    public final String getBody() {
        return this.body;
    }

    @Override
    @Nls
    @NotNull
    public String getLocalizedMessage() {
        Object[] objectArray = new Object[]{this.requestName, String.valueOf(this.statusCode), this.body};
        String string = CollaborationToolsBundle.message("http.status.error", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }
}

