/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ant;

import java.io.File;
import java.util.Locale;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Path;

public class PrefixedPath
extends Path {
    private String myPrefix;

    public PrefixedPath(Project project) {
        super(project);
    }

    public PrefixedPath(Project p, String path) {
        super(p, path);
    }

    public String getPrefix() {
        return this.myPrefix;
    }

    public void setPrefix(String prefix) {
        this.myPrefix = prefix;
    }

    public File findFile(String relativePath) {
        String[] dirsList;
        relativePath = PrefixedPath.trimStartSlash(relativePath);
        String prefix = this.myPrefix;
        if (prefix != null) {
            prefix = PrefixedPath.trimStartSlash(PrefixedPath.ensureEndsWithSlash(prefix));
            if (!relativePath.toLowerCase(Locale.ENGLISH).startsWith(prefix.toLowerCase(Locale.ENGLISH))) {
                return null;
            }
            relativePath = relativePath.substring(prefix.length());
        }
        for (String aDirsList : dirsList = this.list()) {
            String fullPath = PrefixedPath.ensureEndsWithSlash(aDirsList) + relativePath;
            File file = new File(fullPath.replace('/', File.separatorChar));
            if (!file.isFile()) continue;
            return file;
        }
        return null;
    }

    private static String trimStartSlash(String path) {
        if (path.startsWith("/")) {
            return path.substring(1);
        }
        return path;
    }

    private static String ensureEndsWithSlash(String path) {
        if (!path.endsWith("/")) {
            return path + "/";
        }
        return path;
    }
}

