/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.kstream.NamedOperation;
import org.apache.kafka.streams.state.DslStoreSuppliers;
import org.apache.kafka.streams.state.WindowBytesStoreSupplier;

public class StreamJoined<K, V1, V2>
implements NamedOperation<StreamJoined<K, V1, V2>> {
    protected final Serde<K> keySerde;
    protected final Serde<V1> valueSerde;
    protected final Serde<V2> otherValueSerde;
    protected final WindowBytesStoreSupplier thisStoreSupplier;
    protected final WindowBytesStoreSupplier otherStoreSupplier;
    protected final String name;
    protected final String storeName;
    protected final boolean loggingEnabled;
    protected final Map<String, String> topicConfig;
    protected DslStoreSuppliers dslStoreSuppliers;

    protected StreamJoined(StreamJoined<K, V1, V2> streamJoined) {
        this(streamJoined.keySerde, streamJoined.valueSerde, streamJoined.otherValueSerde, streamJoined.dslStoreSuppliers, streamJoined.thisStoreSupplier, streamJoined.otherStoreSupplier, streamJoined.name, streamJoined.storeName, streamJoined.loggingEnabled, streamJoined.topicConfig);
    }

    private StreamJoined(Serde<K> keySerde, Serde<V1> valueSerde, Serde<V2> otherValueSerde, DslStoreSuppliers dslStoreSuppliers, WindowBytesStoreSupplier thisStoreSupplier, WindowBytesStoreSupplier otherStoreSupplier, String name, String storeName, boolean loggingEnabled, Map<String, String> topicConfig) {
        this.keySerde = keySerde;
        this.valueSerde = valueSerde;
        this.otherValueSerde = otherValueSerde;
        this.dslStoreSuppliers = dslStoreSuppliers;
        this.thisStoreSupplier = thisStoreSupplier;
        this.otherStoreSupplier = otherStoreSupplier;
        this.name = name;
        this.storeName = storeName;
        this.loggingEnabled = loggingEnabled;
        this.topicConfig = topicConfig;
    }

    public static <K, V1, V2> StreamJoined<K, V1, V2> with(WindowBytesStoreSupplier storeSupplier, WindowBytesStoreSupplier otherStoreSupplier) {
        return new StreamJoined<K, V1, V2>(null, null, null, null, storeSupplier, otherStoreSupplier, null, null, true, new HashMap<String, String>());
    }

    public static <K, V1, V2> StreamJoined<K, V1, V2> with(DslStoreSuppliers storeSuppliers) {
        return new StreamJoined<K, V1, V2>(null, null, null, storeSuppliers, null, null, null, null, true, new HashMap<String, String>());
    }

    public static <K, V1, V2> StreamJoined<K, V1, V2> as(String storeName) {
        return new StreamJoined<K, V1, V2>(null, null, null, null, null, null, null, storeName, true, new HashMap<String, String>());
    }

    public static <K, V1, V2> StreamJoined<K, V1, V2> with(Serde<K> keySerde, Serde<V1> valueSerde, Serde<V2> otherValueSerde) {
        return new StreamJoined<K, V1, V2>(keySerde, valueSerde, otherValueSerde, null, null, null, null, null, true, new HashMap<String, String>());
    }

    @Override
    public StreamJoined<K, V1, V2> withName(String name) {
        return new StreamJoined<K, V1, V2>(this.keySerde, this.valueSerde, this.otherValueSerde, this.dslStoreSuppliers, this.thisStoreSupplier, this.otherStoreSupplier, name, this.storeName, this.loggingEnabled, this.topicConfig);
    }

    public StreamJoined<K, V1, V2> withStoreName(String storeName) {
        return new StreamJoined<K, V1, V2>(this.keySerde, this.valueSerde, this.otherValueSerde, this.dslStoreSuppliers, this.thisStoreSupplier, this.otherStoreSupplier, this.name, storeName, this.loggingEnabled, this.topicConfig);
    }

    public StreamJoined<K, V1, V2> withKeySerde(Serde<K> keySerde) {
        return new StreamJoined<K, V1, V2>(keySerde, this.valueSerde, this.otherValueSerde, this.dslStoreSuppliers, this.thisStoreSupplier, this.otherStoreSupplier, this.name, this.storeName, this.loggingEnabled, this.topicConfig);
    }

    public StreamJoined<K, V1, V2> withValueSerde(Serde<V1> valueSerde) {
        return new StreamJoined<K, V1, V2>(this.keySerde, valueSerde, this.otherValueSerde, this.dslStoreSuppliers, this.thisStoreSupplier, this.otherStoreSupplier, this.name, this.storeName, this.loggingEnabled, this.topicConfig);
    }

    public StreamJoined<K, V1, V2> withOtherValueSerde(Serde<V2> otherValueSerde) {
        return new StreamJoined<K, V1, V2>(this.keySerde, this.valueSerde, otherValueSerde, this.dslStoreSuppliers, this.thisStoreSupplier, this.otherStoreSupplier, this.name, this.storeName, this.loggingEnabled, this.topicConfig);
    }

    public StreamJoined<K, V1, V2> withDslStoreSuppliers(DslStoreSuppliers dslStoreSuppliers) {
        return new StreamJoined<K, V1, V2>(this.keySerde, this.valueSerde, this.otherValueSerde, dslStoreSuppliers, this.thisStoreSupplier, this.otherStoreSupplier, this.name, this.storeName, this.loggingEnabled, this.topicConfig);
    }

    public StreamJoined<K, V1, V2> withThisStoreSupplier(WindowBytesStoreSupplier thisStoreSupplier) {
        return new StreamJoined<K, V1, V2>(this.keySerde, this.valueSerde, this.otherValueSerde, this.dslStoreSuppliers, thisStoreSupplier, this.otherStoreSupplier, this.name, this.storeName, this.loggingEnabled, this.topicConfig);
    }

    public StreamJoined<K, V1, V2> withOtherStoreSupplier(WindowBytesStoreSupplier otherStoreSupplier) {
        return new StreamJoined<K, V1, V2>(this.keySerde, this.valueSerde, this.otherValueSerde, this.dslStoreSuppliers, this.thisStoreSupplier, otherStoreSupplier, this.name, this.storeName, this.loggingEnabled, this.topicConfig);
    }

    public StreamJoined<K, V1, V2> withLoggingEnabled(Map<String, String> config) {
        return new StreamJoined<K, V1, V2>(this.keySerde, this.valueSerde, this.otherValueSerde, this.dslStoreSuppliers, this.thisStoreSupplier, this.otherStoreSupplier, this.name, this.storeName, true, config);
    }

    public StreamJoined<K, V1, V2> withLoggingDisabled() {
        return new StreamJoined<K, V1, V2>(this.keySerde, this.valueSerde, this.otherValueSerde, this.dslStoreSuppliers, this.thisStoreSupplier, this.otherStoreSupplier, this.name, this.storeName, false, new HashMap<String, String>());
    }

    public String toString() {
        return "StreamJoin{keySerde=" + String.valueOf(this.keySerde) + ", valueSerde=" + String.valueOf(this.valueSerde) + ", otherValueSerde=" + String.valueOf(this.otherValueSerde) + ", thisStoreSupplier=" + String.valueOf(this.thisStoreSupplier) + ", otherStoreSupplier=" + String.valueOf(this.otherStoreSupplier) + ", name='" + this.name + "', storeName='" + this.storeName + "', loggingEnabled=" + this.loggingEnabled + ", topicConfig=" + String.valueOf(this.topicConfig) + "}";
    }
}

