/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.credential.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.common.util.MultivaluedHashMap;

public class PasswordSecretData {
    public static final Logger logger = Logger.getLogger(PasswordSecretData.class);
    private final String value;
    private final byte[] salt;
    private MultivaluedHashMap<String, String> additionalParameters;

    @JsonCreator
    public PasswordSecretData(@JsonProperty(value="value") String value, @JsonProperty(value="salt") String salt, @JsonProperty(value="algorithmData") Map<String, List<String>> additionalParameters) throws IOException {
        MultivaluedHashMap multivaluedHashMap = this.additionalParameters = additionalParameters != null ? new MultivaluedHashMap(additionalParameters) : null;
        if (salt == null || "__SALT__".equals(salt)) {
            this.value = value;
            this.salt = null;
        } else {
            this.value = value;
            this.salt = Base64.getMimeDecoder().decode(salt);
        }
    }

    public PasswordSecretData(String value, byte[] salt) {
        this.value = value;
        this.salt = salt;
        this.additionalParameters = null;
    }

    public String getValue() {
        return this.value;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public MultivaluedHashMap<String, String> getAdditionalParameters() {
        if (this.additionalParameters == null) {
            this.additionalParameters = new MultivaluedHashMap();
        }
        return this.additionalParameters;
    }
}

