/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.sdjwt.vp;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.security.cert.Certificate;
import java.util.List;
import java.util.Optional;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.jose.jws.JWSHeader;
import org.keycloak.sdjwt.JwsToken;

public class KeyBindingJWT
extends JwsToken {
    public KeyBindingJWT(String jwsString) {
        super(jwsString);
    }

    protected KeyBindingJWT(JWSHeader jwsHeader, ObjectNode payload, SignatureSignerContext signer) {
        super(jwsHeader, payload);
        this.getJwsHeader().setType("kb+jwt");
        Optional.ofNullable(signer).ifPresent(this::sign);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        protected JWSHeader jwsHeader = new JWSHeader();
        protected ObjectNode payload = JsonNodeFactory.instance.objectNode();
        private SignatureSignerContext signerContext;

        private JWSHeader getJwsHeader() {
            if (this.jwsHeader == null) {
                this.jwsHeader = new JWSHeader();
            }
            return this.jwsHeader;
        }

        private ObjectNode getPayload() {
            if (this.payload == null) {
                this.payload = JsonNodeFactory.instance.objectNode();
            }
            return this.payload;
        }

        public Builder withJwsHeader(JWSHeader jwsHeader) {
            this.jwsHeader = jwsHeader;
            return this;
        }

        public Builder withPayload(ObjectNode payload) {
            this.payload = payload;
            return this;
        }

        public Builder withIat(long iat) {
            this.getPayload().put("iat", iat);
            return this;
        }

        public Builder withNbf(long nbf) {
            this.getPayload().put("nbf", nbf);
            return this;
        }

        public Builder withExp(long exp) {
            this.getPayload().put("exp", exp);
            return this;
        }

        public Builder withNonce(String nonce) {
            this.getPayload().put("nonce", nonce);
            return this;
        }

        public Builder withAudience(String aud) {
            this.getPayload().put("aud", aud);
            return this;
        }

        public Builder withKid(String kid) {
            this.getJwsHeader().setKeyId(kid);
            return this;
        }

        public Builder withX5c(List<String> x5c) {
            this.getJwsHeader().setX5c(x5c);
            return this;
        }

        public Builder withX5c(String x5c) {
            this.getJwsHeader().addX5c(x5c);
            return this;
        }

        public Builder withX5c(Certificate x5c) {
            this.getJwsHeader().addX5c(x5c);
            return this;
        }

        public Builder withSignerContext(SignatureSignerContext signatureSignerContext) {
            this.signerContext = signatureSignerContext;
            return this;
        }

        public KeyBindingJWT build() {
            return new KeyBindingJWT(this.jwsHeader, this.payload, this.signerContext);
        }
    }
}

