/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin.fgap;

import org.keycloak.common.Profile;
import org.keycloak.models.ClientModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.provider.ProviderEventManager;
import org.keycloak.services.resources.admin.AdminAuth;
import org.keycloak.services.resources.admin.fgap.AdminPermissionEvaluator;
import org.keycloak.services.resources.admin.fgap.AdminPermissionManagement;
import org.keycloak.services.resources.admin.fgap.MgmtPermissions;
import org.keycloak.services.resources.admin.fgap.MgmtPermissionsV2;
import org.keycloak.services.resources.admin.fgap.RealmsPermissionEvaluator;

public class AdminPermissions {
    public static AdminPermissionEvaluator evaluator(KeycloakSession session, RealmModel realm, AdminAuth auth) {
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ADMIN_FINE_GRAINED_AUTHZ_V2)) {
            return new MgmtPermissionsV2(session, realm, auth);
        }
        return new MgmtPermissions(session, realm, auth);
    }

    public static AdminPermissionEvaluator evaluator(KeycloakSession session, RealmModel realm, RealmModel adminsRealm, UserModel admin) {
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ADMIN_FINE_GRAINED_AUTHZ_V2)) {
            return new MgmtPermissionsV2(session, adminsRealm, admin);
        }
        return new MgmtPermissions(session, realm, adminsRealm, admin);
    }

    public static RealmsPermissionEvaluator realms(KeycloakSession session, AdminAuth auth) {
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ADMIN_FINE_GRAINED_AUTHZ_V2)) {
            return new MgmtPermissionsV2(session, auth);
        }
        return new MgmtPermissions(session, auth);
    }

    public static AdminPermissionManagement management(KeycloakSession session, RealmModel realm) {
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ADMIN_FINE_GRAINED_AUTHZ_V2)) {
            return new MgmtPermissionsV2(session, realm);
        }
        return new MgmtPermissions(session, realm);
    }

    public static void registerListener(ProviderEventManager manager) {
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ADMIN_FINE_GRAINED_AUTHZ)) {
            manager.register(event -> {
                if (event instanceof RoleContainerModel.RoleRemovedEvent) {
                    RoleContainerModel.RoleRemovedEvent cast = (RoleContainerModel.RoleRemovedEvent)event;
                    RoleModel role = cast.getRole();
                    RealmModel realm = role.getContainer() instanceof ClientModel ? ((ClientModel)role.getContainer()).getRealm() : (RealmModel)role.getContainer();
                    AdminPermissions.management(cast.getKeycloakSession(), realm).roles().setPermissionsEnabled(role, false);
                } else if (event instanceof ClientModel.ClientRemovedEvent) {
                    ClientModel.ClientRemovedEvent cast = (ClientModel.ClientRemovedEvent)event;
                    AdminPermissions.management(cast.getKeycloakSession(), cast.getClient().getRealm()).clients().setPermissionsEnabled(cast.getClient(), false);
                } else if (event instanceof GroupModel.GroupRemovedEvent) {
                    GroupModel.GroupRemovedEvent cast = (GroupModel.GroupRemovedEvent)event;
                    AdminPermissions.management(cast.getKeycloakSession(), cast.getRealm()).groups().setPermissionsEnabled(cast.getGroup(), false);
                }
            });
        }
    }
}

