/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifier;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifierList;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.resolve.Compatibility;
import org.jetbrains.kotlin.resolve.ModifierCheckerHelpersKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001aY\u0010\u0000\u001a\u00020\u00012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u00072\u0010\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0000R\u00020\u0002R\u00020\u0004j\u0006\u0010\u0003\u001a\u00020\u0002j\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\r\u001aG\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0010\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\nH\u0002R\u00020\u0002R\u00020\u0004j\u0006\u0010\u0003\u001a\u00020\u0002j\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0011\u001a+\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013R\u00020\u0004R\u00020\u0002j\u0006\u0010\u0005\u001a\u00020\u0004j\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0014\u00a8\u0006\u0015"}, d2={"checkCompatibilityType", "", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "firstModifier", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirModifier;", "secondModifier", "reportedNodes", "", "owner", "Lorg/jetbrains/kotlin/fir/FirElement;", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/analysis/checkers/FirModifier;Lorg/jetbrains/kotlin/fir/analysis/checkers/FirModifier;Ljava/util/Set;Lorg/jetbrains/kotlin/fir/FirElement;)V", "checkModifiersCompatibility", "modifierList", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirModifierList;", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/FirElement;Lorg/jetbrains/kotlin/fir/analysis/checkers/FirModifierList;Ljava/util/Set;)V", "typeArgument", "Lorg/jetbrains/kotlin/fir/types/FirTypeProjection;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/types/FirTypeProjection;)V", "checkers"})
@SourceDebugExtension(value={"SMAP\nModifiersCompatibilityUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModifiersCompatibilityUtils.kt\norg/jetbrains/kotlin/fir/analysis/checkers/ModifiersCompatibilityUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,115:1\n1#2:116\n*E\n"})
public final class ModifiersCompatibilityUtilsKt {
    public static final void checkCompatibilityType(@NotNull DiagnosticReporter reporter, @NotNull CheckerContext context2, @NotNull FirModifier<?> firstModifier, @NotNull FirModifier<?> secondModifier, @NotNull Set<FirModifier<?>> reportedNodes, @Nullable FirElement owner) {
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(firstModifier, "firstModifier");
        Intrinsics.checkNotNullParameter(secondModifier, "secondModifier");
        Intrinsics.checkNotNullParameter(reportedNodes, "reportedNodes");
        KtModifierKeywordToken firstModifierToken = firstModifier.getToken();
        KtModifierKeywordToken secondModifierToken = secondModifier.getToken();
        Compatibility compatibilityType = ModifierCheckerHelpersKt.compatibility(firstModifierToken, secondModifierToken);
        switch (WhenMappings.$EnumSwitchMapping$0[compatibilityType.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                if (!reportedNodes.add(secondModifier)) break;
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)secondModifier.getSource(), FirErrors.INSTANCE.getREPEATED_MODIFIER(), (Object)secondModifierToken, null, 16, null);
                break;
            }
            case 3: {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)secondModifier.getSource(), FirErrors.INSTANCE.getREDUNDANT_MODIFIER(), (Object)secondModifierToken, (Object)firstModifierToken, null, 32, null);
                break;
            }
            case 4: {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)firstModifier.getSource(), FirErrors.INSTANCE.getREDUNDANT_MODIFIER(), (Object)firstModifierToken, (Object)secondModifierToken, null, 32, null);
                break;
            }
            case 5: {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)firstModifier.getSource(), FirErrors.INSTANCE.getDEPRECATED_MODIFIER_PAIR(), (Object)firstModifierToken, (Object)secondModifierToken, null, 32, null);
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)secondModifier.getSource(), FirErrors.INSTANCE.getDEPRECATED_MODIFIER_PAIR(), (Object)secondModifierToken, (Object)firstModifierToken, null, 32, null);
                break;
            }
            case 6: 
            case 7: {
                if (compatibilityType == Compatibility.COMPATIBLE_FOR_CLASSES_ONLY && owner instanceof FirClass) {
                    return;
                }
                if (reportedNodes.add(firstModifier)) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)firstModifier.getSource(), FirErrors.INSTANCE.getINCOMPATIBLE_MODIFIERS(), (Object)firstModifierToken, (Object)secondModifierToken, null, 32, null);
                }
                if (!reportedNodes.add(secondModifier)) break;
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)secondModifier.getSource(), FirErrors.INSTANCE.getINCOMPATIBLE_MODIFIERS(), (Object)secondModifierToken, (Object)firstModifierToken, null, 32, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private static final void checkModifiersCompatibility(DiagnosticReporter reporter, CheckerContext context2, FirElement owner, FirModifierList modifierList2, Set<FirModifier<?>> reportedNodes) {
        List<FirModifier<?>> modifiers = modifierList2.getModifiers();
        Iterator iterator2 = ((Iterable)modifiers).iterator();
        int n2 = 0;
        while (iterator2.hasNext()) {
            int secondIndex = n2++;
            FirModifier secondModifier = (FirModifier)iterator2.next();
            for (int firstIndex = 0; firstIndex < secondIndex; ++firstIndex) {
                ModifiersCompatibilityUtilsKt.checkCompatibilityType(reporter, context2, modifiers.get(firstIndex), secondModifier, reportedNodes, owner);
            }
        }
    }

    public static final void checkModifiersCompatibility(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirTypeProjection typeArgument) {
        KtSourceElement ktSourceElement;
        block5: {
            block4: {
                KtSourceElement ktSourceElement2;
                Intrinsics.checkNotNullParameter(context2, "context");
                Intrinsics.checkNotNullParameter(reporter, "reporter");
                Intrinsics.checkNotNullParameter(typeArgument, "typeArgument");
                ktSourceElement = typeArgument.getSource();
                if (ktSourceElement == null) break block4;
                KtSourceElement it = ktSourceElement2 = ktSourceElement;
                boolean bl = false;
                ktSourceElement = it.getKind() instanceof KtRealSourceElementKind ? ktSourceElement2 : null;
                if (ktSourceElement != null) break block5;
            }
            return;
        }
        KtSourceElement source = ktSourceElement;
        FirModifierList firModifierList = FirKeywordUtilsKt.getModifierList(source);
        if (firModifierList == null) {
            return;
        }
        FirModifierList modifierList2 = firModifierList;
        HashSet reportedNodes = new HashSet();
        ModifiersCompatibilityUtilsKt.checkModifiersCompatibility(reporter, context2, typeArgument, modifierList2, reportedNodes);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Compatibility.values().length];
            try {
                nArray[Compatibility.COMPATIBLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Compatibility.REPEATED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Compatibility.REDUNDANT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Compatibility.REVERSE_REDUNDANT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Compatibility.DEPRECATED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Compatibility.INCOMPATIBLE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Compatibility.COMPATIBLE_FOR_CLASSES_ONLY.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

