/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.request;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import lombok.Generated;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.script.Script;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregationBuilders;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.BucketOrder;
import org.opensearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.opensearch.search.aggregations.bucket.composite.TermsValuesSourceBuilder;
import org.opensearch.search.aggregations.bucket.histogram.AutoDateHistogramAggregationBuilder;
import org.opensearch.search.aggregations.bucket.missing.MissingOrder;
import org.opensearch.search.aggregations.bucket.range.RangeAggregationBuilder;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.opensearch.search.aggregations.metrics.ExtendedStats;
import org.opensearch.search.aggregations.metrics.PercentilesAggregationBuilder;
import org.opensearch.search.aggregations.metrics.TopHitsAggregationBuilder;
import org.opensearch.search.aggregations.metrics.ValueCountAggregationBuilder;
import org.opensearch.search.aggregations.support.ValueType;
import org.opensearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.sort.SortOrder;
import org.opensearch.sql.ast.expression.SpanUnit;
import org.opensearch.sql.calcite.utils.OpenSearchTypeFactory;
import org.opensearch.sql.calcite.utils.PlanUtils;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.expression.function.PPLBuiltinOperators;
import org.opensearch.sql.opensearch.data.type.OpenSearchDataType;
import org.opensearch.sql.opensearch.request.AggregateFilterAnalyzer;
import org.opensearch.sql.opensearch.request.CaseRangeAnalyzer;
import org.opensearch.sql.opensearch.request.PredicateAnalyzer;
import org.opensearch.sql.opensearch.response.agg.ArgMaxMinParser;
import org.opensearch.sql.opensearch.response.agg.BucketAggregationParser;
import org.opensearch.sql.opensearch.response.agg.CountAsTotalHitsParser;
import org.opensearch.sql.opensearch.response.agg.MetricParser;
import org.opensearch.sql.opensearch.response.agg.NoBucketAggregationParser;
import org.opensearch.sql.opensearch.response.agg.OpenSearchAggregationResponseParser;
import org.opensearch.sql.opensearch.response.agg.SinglePercentileParser;
import org.opensearch.sql.opensearch.response.agg.SingleValueParser;
import org.opensearch.sql.opensearch.response.agg.StatsParser;
import org.opensearch.sql.opensearch.response.agg.TopHitsParser;
import org.opensearch.sql.opensearch.storage.script.aggregation.dsl.CompositeAggregationBuilder;
import shaded.com.google.common.base.Throwables;
import shaded.com.google.common.collect.ImmutableList;

public class AggregateAnalyzer {
    private static final String METADATA_FIELD = "_index";

    private AggregateAnalyzer() {
    }

    public static Pair<List<AggregationBuilder>, OpenSearchAggregationResponseParser> analyze(Aggregate aggregate, Project project, List<String> outputFields, AggregateBuilderHelper helper) throws ExpressionNotAnalyzableException {
        Objects.requireNonNull(aggregate, "aggregate");
        try {
            List<Integer> groupList = aggregate.getGroupSet().asList();
            List<String> aggFieldNames = outputFields.subList(groupList.size(), outputFields.size());
            Pair<AggregatorFactories.Builder, List<MetricParser>> builderAndParser = AggregateAnalyzer.processAggregateCalls(aggFieldNames, aggregate.getAggCallList(), project, helper);
            AggregatorFactories.Builder metricBuilder = (AggregatorFactories.Builder)builderAndParser.getLeft();
            List metricParsers = (List)builderAndParser.getRight();
            boolean countAllOnly = !groupList.isEmpty();
            Pair<List<String>, AggregatorFactories.Builder> countAggNameAndBuilderPair = AggregateAnalyzer.removeCountAggregationBuilders(metricBuilder, countAllOnly);
            AggregatorFactories.Builder newMetricBuilder = (AggregatorFactories.Builder)countAggNameAndBuilderPair.getRight();
            List countAggNames = (List)countAggNameAndBuilderPair.getLeft();
            if (aggregate.getGroupSet().isEmpty()) {
                if (newMetricBuilder == null) {
                    return Pair.of(List.of(), (Object)new CountAsTotalHitsParser(countAggNames));
                }
                return Pair.of((Object)ImmutableList.copyOf((Collection)newMetricBuilder.getAggregatorFactories()), (Object)new NoBucketAggregationParser(metricParsers));
            }
            AggregatorFactories.Builder subBuilder = newMetricBuilder;
            Pair<Set<Integer>, AggregationBuilder> aggPushedAndAggBuilder = AggregateAnalyzer.createNestedAggregation(groupList, project, subBuilder, helper);
            Set aggPushed = (Set)aggPushedAndAggBuilder.getLeft();
            AggregationBuilder pushedAggBuilder = (AggregationBuilder)aggPushedAndAggBuilder.getRight();
            groupList = groupList.stream().filter(i -> !aggPushed.contains(i)).toList();
            if (pushedAggBuilder != null) {
                subBuilder = new AggregatorFactories.Builder().addAggregator(pushedAggBuilder);
            }
            if (groupList.isEmpty()) {
                return Pair.of((Object)ImmutableList.copyOf((Collection)subBuilder.getAggregatorFactories()), (Object)new BucketAggregationParser(metricParsers, countAggNames));
            }
            List<CompositeValuesSourceBuilder<?>> buckets = AggregateAnalyzer.createCompositeBuckets(groupList, project, helper);
            if (buckets.size() != groupList.size()) {
                throw new UnsupportedOperationException("Not all the left aggregations can be converted to value sources of composite aggregation");
            }
            org.opensearch.search.aggregations.bucket.composite.CompositeAggregationBuilder compositeBuilder = AggregationBuilders.composite((String)"composite_buckets", buckets).size(helper.bucketSize);
            if (subBuilder != null) {
                compositeBuilder.subAggregations(subBuilder);
            }
            return Pair.of(Collections.singletonList(compositeBuilder), (Object)new BucketAggregationParser(metricParsers, countAggNames));
        }
        catch (Throwable e) {
            Throwables.throwIfInstanceOf((Throwable)e, UnsupportedOperationException.class);
            throw new ExpressionNotAnalyzableException("Can't convert " + String.valueOf(aggregate), e);
        }
    }

    private static Pair<List<String>, AggregatorFactories.Builder> removeCountAggregationBuilders(AggregatorFactories.Builder metricBuilder, boolean countAllOnly) {
        List<ValueCountAggregationBuilder> countAggregatorFactories = metricBuilder.getAggregatorFactories().stream().filter(ValueCountAggregationBuilder.class::isInstance).map(ValueCountAggregationBuilder.class::cast).filter(vc -> vc.script() == null).filter(vc -> !countAllOnly || vc.fieldName().equals(METADATA_FIELD)).toList();
        ArrayList copy = new ArrayList(metricBuilder.getAggregatorFactories());
        copy.removeAll(countAggregatorFactories);
        AggregatorFactories.Builder newMetricBuilder = new AggregatorFactories.Builder();
        copy.forEach(arg_0 -> ((AggregatorFactories.Builder)newMetricBuilder).addAggregator(arg_0));
        if (countAllOnly || AggregateAnalyzer.supportCountFiled(countAggregatorFactories, metricBuilder)) {
            List<String> countAggNameList = countAggregatorFactories.stream().map(AggregationBuilder::getName).toList();
            if (newMetricBuilder.getAggregatorFactories().isEmpty()) {
                newMetricBuilder = null;
            }
            return Pair.of(countAggNameList, (Object)newMetricBuilder);
        }
        return Pair.of(List.of(), (Object)metricBuilder);
    }

    private static boolean supportCountFiled(List<ValueCountAggregationBuilder> countAggBuilderList, AggregatorFactories.Builder metricBuilder) {
        return countAggBuilderList.size() == metricBuilder.getAggregatorFactories().size() && countAggBuilderList.stream().map(ValuesSourceAggregationBuilder::fieldName).distinct().count() == 1L;
    }

    private static Pair<AggregatorFactories.Builder, List<MetricParser>> processAggregateCalls(List<String> aggFieldNames, List<AggregateCall> aggCalls, Project project, AggregateBuilderHelper helper) throws PredicateAnalyzer.ExpressionNotAnalyzableException {
        AggregatorFactories.Builder metricBuilder = new AggregatorFactories.Builder();
        ArrayList<MetricParser> metricParserList = new ArrayList<MetricParser>();
        AggregateFilterAnalyzer aggFilterAnalyzer = new AggregateFilterAnalyzer(helper, project);
        for (int i = 0; i < aggCalls.size(); ++i) {
            AggregateCall aggCall = aggCalls.get(i);
            List<RexNode> args = AggregateAnalyzer.convertAggArgThroughProject(aggCall, project);
            String aggFieldName = aggFieldNames.get(i);
            Pair<AggregationBuilder, MetricParser> builderAndParser = AggregateAnalyzer.createAggregationBuilderAndParser(aggCall, args, aggFieldName, helper);
            builderAndParser = aggFilterAnalyzer.analyze(builderAndParser, aggCall, aggFieldName);
            metricBuilder.addAggregator((AggregationBuilder)builderAndParser.getLeft());
            metricParserList.add((MetricParser)builderAndParser.getRight());
        }
        return Pair.of((Object)metricBuilder, metricParserList);
    }

    private static List<RexNode> convertAggArgThroughProject(AggregateCall aggCall, Project project) {
        return project == null ? List.of() : (PlanUtils.getObjectFromLiteralAgg(aggCall) != null ? project.getProjects().stream().filter(rex -> !rex.isA(SqlKind.ROW_NUMBER)).toList() : aggCall.getArgList().stream().map(project.getProjects()::get).toList());
    }

    private static Pair<AggregationBuilder, MetricParser> createAggregationBuilderAndParser(AggregateCall aggCall, List<RexNode> args, String aggFieldName, AggregateBuilderHelper helper) {
        if (aggCall.isDistinct()) {
            return AggregateAnalyzer.createDistinctAggregation(aggCall, args, aggFieldName, helper);
        }
        return AggregateAnalyzer.createRegularAggregation(aggCall, args, aggFieldName, helper);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Pair<AggregationBuilder, MetricParser> createDistinctAggregation(AggregateCall aggCall, List<RexNode> args, String aggFieldName, AggregateBuilderHelper helper) {
        switch (aggCall.getAggregation().kind) {
            case COUNT: {
                return Pair.of((Object)helper.build(!args.isEmpty() ? args.getFirst() : null, AggregationBuilders.cardinality((String)aggFieldName)), (Object)new SingleValueParser(aggFieldName));
            }
            default: {
                throw new AggregateAnalyzerException(String.format("unsupported distinct aggregator %s", aggCall.getAggregation()));
            }
        }
    }

    private static Pair<AggregationBuilder, MetricParser> createRegularAggregation(AggregateCall aggCall, List<RexNode> args, String aggFieldName, AggregateBuilderHelper helper) {
        return switch (aggCall.getAggregation().kind) {
            case SqlKind.AVG -> Pair.of((Object)helper.build(args.getFirst(), AggregationBuilders.avg((String)aggFieldName)), (Object)new SingleValueParser(aggFieldName));
            case SqlKind.SUM -> Pair.of((Object)helper.build(args.getFirst(), AggregationBuilders.sum((String)aggFieldName)), (Object)new SingleValueParser(aggFieldName));
            case SqlKind.COUNT -> Pair.of((Object)helper.build(!args.isEmpty() ? args.getFirst() : null, AggregationBuilders.count((String)aggFieldName)), (Object)new SingleValueParser(aggFieldName));
            case SqlKind.MIN -> {
                ExprType fieldType = OpenSearchTypeFactory.convertRelDataTypeToExprType(args.getFirst().getType());
                if (AggregateAnalyzer.supportsMaxMinAggregation(fieldType)) {
                    yield Pair.of((Object)helper.build(args.getFirst(), AggregationBuilders.min((String)aggFieldName)), (Object)new SingleValueParser(aggFieldName));
                }
                yield Pair.of((Object)AggregationBuilders.topHits((String)aggFieldName).fetchField(helper.inferNamedField(args.getFirst()).getReferenceForTermQuery()).size(1).from(0).sort(helper.inferNamedField(args.getFirst()).getReferenceForTermQuery(), SortOrder.ASC), (Object)new TopHitsParser(aggFieldName, true, false));
            }
            case SqlKind.MAX -> {
                ExprType fieldType = OpenSearchTypeFactory.convertRelDataTypeToExprType(args.getFirst().getType());
                if (AggregateAnalyzer.supportsMaxMinAggregation(fieldType)) {
                    yield Pair.of((Object)helper.build(args.getFirst(), AggregationBuilders.max((String)aggFieldName)), (Object)new SingleValueParser(aggFieldName));
                }
                yield Pair.of((Object)AggregationBuilders.topHits((String)aggFieldName).fetchField(helper.inferNamedField(args.getFirst()).getReferenceForTermQuery()).size(1).from(0).sort(helper.inferNamedField(args.getFirst()).getReferenceForTermQuery(), SortOrder.DESC), (Object)new TopHitsParser(aggFieldName, true, false));
            }
            case SqlKind.VAR_SAMP -> Pair.of((Object)helper.build(args.getFirst(), AggregationBuilders.extendedStats((String)aggFieldName)), (Object)new StatsParser(ExtendedStats::getVarianceSampling, aggFieldName));
            case SqlKind.VAR_POP -> Pair.of((Object)helper.build(args.getFirst(), AggregationBuilders.extendedStats((String)aggFieldName)), (Object)new StatsParser(ExtendedStats::getVariancePopulation, aggFieldName));
            case SqlKind.STDDEV_SAMP -> Pair.of((Object)helper.build(args.getFirst(), AggregationBuilders.extendedStats((String)aggFieldName)), (Object)new StatsParser(ExtendedStats::getStdDeviationSampling, aggFieldName));
            case SqlKind.STDDEV_POP -> Pair.of((Object)helper.build(args.getFirst(), AggregationBuilders.extendedStats((String)aggFieldName)), (Object)new StatsParser(ExtendedStats::getStdDeviationPopulation, aggFieldName));
            case SqlKind.ARG_MAX -> Pair.of((Object)AggregationBuilders.topHits((String)aggFieldName).fetchField(helper.inferNamedField(args.getFirst()).getReferenceForTermQuery()).size(1).from(0).sort(helper.inferNamedField(args.get(1)).getReferenceForTermQuery(), SortOrder.DESC), (Object)new ArgMaxMinParser(aggFieldName));
            case SqlKind.ARG_MIN -> Pair.of((Object)AggregationBuilders.topHits((String)aggFieldName).fetchField(helper.inferNamedField(args.getFirst()).getReferenceForTermQuery()).size(1).from(0).sort(helper.inferNamedField(args.get(1)).getReferenceForTermQuery(), SortOrder.ASC), (Object)new ArgMaxMinParser(aggFieldName));
            case SqlKind.OTHER_FUNCTION -> {
                BuiltinFunctionName functionName = BuiltinFunctionName.ofAggregation(aggCall.getAggregation().getName()).get();
                switch (functionName) {
                    case TAKE: {
                        yield Pair.of((Object)AggregationBuilders.topHits((String)aggFieldName).fetchField(helper.inferNamedField(args.getFirst()).getReferenceForTermQuery()).size(helper.inferValue(args.getLast(), Integer.class).intValue()).from(0), (Object)new TopHitsParser(aggFieldName, false, true));
                    }
                    case FIRST: {
                        TopHitsAggregationBuilder firstBuilder = AggregationBuilders.topHits((String)aggFieldName).size(1).from(0);
                        if (!args.isEmpty()) {
                            firstBuilder.fetchField(helper.inferNamedField(args.getFirst()).getReferenceForTermQuery());
                        }
                        yield Pair.of((Object)firstBuilder, (Object)new TopHitsParser(aggFieldName, true, false));
                    }
                    case LAST: {
                        TopHitsAggregationBuilder lastBuilder = AggregationBuilders.topHits((String)aggFieldName).size(1).from(0).sort("_doc", SortOrder.DESC);
                        if (!args.isEmpty()) {
                            lastBuilder.fetchField(helper.inferNamedField(args.getFirst()).getReferenceForTermQuery());
                        }
                        yield Pair.of((Object)lastBuilder, (Object)new TopHitsParser(aggFieldName, true, false));
                    }
                    case PERCENTILE_APPROX: {
                        PercentilesAggregationBuilder aggBuilder = helper.build(args.getFirst(), AggregationBuilders.percentiles((String)aggFieldName)).percentiles(new double[]{helper.inferValue(args.get(1), Double.class)});
                        if (args.size() > 3) {
                            aggBuilder.compression(helper.inferValue(args.getLast(), Double.class).doubleValue());
                        }
                        yield Pair.of((Object)aggBuilder, (Object)new SinglePercentileParser(aggFieldName));
                    }
                    case DISTINCT_COUNT_APPROX: {
                        yield Pair.of((Object)helper.build(!args.isEmpty() ? args.getFirst() : null, AggregationBuilders.cardinality((String)aggFieldName)), (Object)new SingleValueParser(aggFieldName));
                    }
                }
                throw new AggregateAnalyzerException(String.format("Unsupported push-down aggregator %s", aggCall.getAggregation()));
            }
            case SqlKind.LITERAL_AGG -> {
                RexLiteral literal = PlanUtils.getObjectFromLiteralAgg(aggCall);
                if (literal == null || !(literal.getValue() instanceof Number)) {
                    throw new AggregateAnalyzerException(String.format("Unsupported push-down aggregator %s", aggCall.getAggregation()));
                }
                Integer dedupNumber = (Integer)literal.getValueAs(Integer.class);
                TopHitsAggregationBuilder topHitsAggregationBuilder = AggregationBuilders.topHits((String)aggFieldName).from(0).size(dedupNumber.intValue());
                ArrayList sources = new ArrayList();
                ArrayList scripts = new ArrayList();
                args.forEach(rex -> {
                    if (rex instanceof RexInputRef) {
                        sources.add(helper.inferNamedField((RexNode)rex).getReference());
                    } else if (rex instanceof RexCall || rex instanceof RexLiteral) {
                        scripts.add(new SearchSourceBuilder.ScriptField(rex.toString(), helper.inferScript((RexNode)rex).getScript(), false));
                    } else {
                        throw new AggregateAnalyzerException(String.format("Unsupported push-down aggregator %s due to rex type is %s", aggCall.getAggregation(), rex.getKind()));
                    }
                });
                topHitsAggregationBuilder.fetchSource((String[])sources.stream().distinct().toArray(String[]::new), new String[0]);
                topHitsAggregationBuilder.scriptFields(scripts);
                yield Pair.of((Object)topHitsAggregationBuilder, (Object)new TopHitsParser(aggFieldName, false, false));
            }
            default -> throw new AggregateAnalyzerException(String.format("unsupported aggregator %s", aggCall.getAggregation()));
        };
    }

    private static boolean supportsMaxMinAggregation(ExprType fieldType) {
        ExprType coreType = fieldType instanceof OpenSearchDataType ? ((OpenSearchDataType)fieldType).getExprType() : fieldType;
        return ExprCoreType.numberTypes().contains(coreType) || coreType == ExprCoreType.DATE || coreType == ExprCoreType.TIME || coreType == ExprCoreType.TIMESTAMP;
    }

    private static List<CompositeValuesSourceBuilder<?>> createCompositeBuckets(List<Integer> groupList, Project project, AggregateBuilderHelper helper) {
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        groupList.forEach(groupIndex -> resultBuilder.add(AggregateAnalyzer.createCompositeBucket(groupIndex, project, helper)));
        return resultBuilder.build();
    }

    private static Pair<Set<Integer>, AggregationBuilder> createNestedAggregation(List<Integer> groupList, Project project, AggregatorFactories.Builder metricBuilder, AggregateBuilderHelper helper) {
        ValuesSourceAggregationBuilder<?> rootAggBuilder = null;
        ValuesSourceAggregationBuilder<?> tailAggBuilder = null;
        HashSet<Integer> aggPushed = new HashSet<Integer>();
        for (Integer i : groupList) {
            String name;
            RexNode agg = (RexNode)project.getProjects().get(i);
            ValuesSourceAggregationBuilder<?> aggBuilder = AggregateAnalyzer.createCompositeIncompatibleAggregation(agg, name = (String)((org.apache.calcite.util.Pair)project.getNamedProjects().get(i)).getValue(), helper);
            if (aggBuilder == null) continue;
            aggPushed.add(i);
            if (rootAggBuilder == null) {
                rootAggBuilder = aggBuilder;
            } else {
                tailAggBuilder.subAggregation(aggBuilder);
            }
            tailAggBuilder = aggBuilder;
        }
        if (tailAggBuilder != null && metricBuilder != null) {
            tailAggBuilder.subAggregations(metricBuilder);
        }
        return Pair.of(aggPushed, rootAggBuilder);
    }

    private static ValuesSourceAggregationBuilder<?> createCompositeIncompatibleAggregation(RexNode agg, String name, AggregateBuilderHelper helper) {
        Optional<RangeAggregationBuilder> rangeAggBuilder;
        AutoDateHistogramAggregationBuilder aggBuilder = null;
        if (AggregateAnalyzer.isAutoDateSpan(agg)) {
            aggBuilder = AggregateAnalyzer.analyzeAutoDateSpan(agg, name, helper);
        } else if (AggregateAnalyzer.isCase(agg) && (rangeAggBuilder = CaseRangeAnalyzer.create(name, helper.rowType).analyze((RexCall)agg)).isPresent()) {
            aggBuilder = (ValuesSourceAggregationBuilder)rangeAggBuilder.get();
        }
        return aggBuilder;
    }

    private static AutoDateHistogramAggregationBuilder analyzeAutoDateSpan(RexNode spanAgg, String name, AggregateBuilderHelper helper) {
        RexCall rexCall = (RexCall)spanAgg;
        RexInputRef rexInputRef = (RexInputRef)rexCall.getOperands().getFirst();
        RexLiteral valueLiteral = (RexLiteral)rexCall.getOperands().get(1);
        return ((AutoDateHistogramAggregationBuilder)new AutoDateHistogramAggregationBuilder(name).field(helper.inferNamedField((RexNode)rexInputRef).getRootName())).setNumBuckets(Objects.requireNonNull((Integer)valueLiteral.getValueAs(Integer.class)).intValue());
    }

    private static boolean isAutoDateSpan(RexNode rex) {
        RexCall rexCall;
        return rex instanceof RexCall && (rexCall = (RexCall)rex).getKind() == SqlKind.OTHER_FUNCTION && rexCall.getOperator().equals((Object)PPLBuiltinOperators.WIDTH_BUCKET);
    }

    private static boolean isCase(RexNode rex) {
        RexCall rexCall;
        return rex instanceof RexCall && (rexCall = (RexCall)rex).getKind() == SqlKind.CASE;
    }

    private static CompositeValuesSourceBuilder<?> createCompositeBucket(Integer groupIndex, Project project, AggregateBuilderHelper helper) {
        Object e;
        RexCall rexCall;
        RexNode rex = (RexNode)project.getProjects().get(groupIndex);
        String bucketName = (String)project.getRowType().getFieldNames().get(groupIndex);
        if (rex instanceof RexCall && (rexCall = (RexCall)rex).getKind() == SqlKind.OTHER_FUNCTION && rexCall.getOperator().getName().equalsIgnoreCase(BuiltinFunctionName.SPAN.name()) && rexCall.getOperands().size() == 3 && (e = rexCall.getOperands().getFirst()) instanceof RexInputRef) {
            RexInputRef rexInputRef = (RexInputRef)e;
            e = rexCall.getOperands().get(1);
            if (e instanceof RexLiteral) {
                RexLiteral valueLiteral = (RexLiteral)e;
                e = rexCall.getOperands().get(2);
                if (e instanceof RexLiteral) {
                    RexLiteral unitLiteral = (RexLiteral)e;
                    return CompositeAggregationBuilder.buildHistogram(bucketName, helper.inferNamedField((RexNode)rexInputRef).getRootName(), (Double)valueLiteral.getValueAs(Double.class), SpanUnit.of((String)unitLiteral.getValueAs(String.class)), MissingOrder.FIRST, helper.bucketNullable);
                }
            }
        }
        return AggregateAnalyzer.createTermsSourceBuilder(bucketName, rex, helper);
    }

    private static CompositeValuesSourceBuilder<?> createTermsSourceBuilder(String bucketName, RexNode group, AggregateBuilderHelper helper) {
        TermsValuesSourceBuilder termsBuilder = (TermsValuesSourceBuilder)new TermsValuesSourceBuilder(bucketName).order(SortOrder.ASC);
        if (helper.bucketNullable) {
            ((TermsValuesSourceBuilder)termsBuilder.missingBucket(true)).missingOrder(MissingOrder.FIRST);
        }
        TermsValuesSourceBuilder sourceBuilder = helper.build(group, termsBuilder);
        return AggregateAnalyzer.withValueTypeHint(sourceBuilder, arg_0 -> ((CompositeValuesSourceBuilder)sourceBuilder).userValuetypeHint(arg_0), group.getType(), group instanceof RexInputRef);
    }

    private static ValuesSourceAggregationBuilder<?> createTermsAggregationBuilder(String bucketName, RexNode group, AggregateBuilderHelper helper) {
        TermsAggregationBuilder sourceBuilder = helper.build(group, new TermsAggregationBuilder(bucketName).size(helper.bucketSize).order(BucketOrder.key((boolean)true)));
        return (ValuesSourceAggregationBuilder)AggregateAnalyzer.withValueTypeHint(sourceBuilder, arg_0 -> ((TermsAggregationBuilder)sourceBuilder).userValueTypeHint(arg_0), group.getType(), group instanceof RexInputRef);
    }

    private static <T> T withValueTypeHint(T sourceBuilder, Function<ValueType, T> withValueTypeHint, RelDataType groupType, boolean isSourceField) {
        ExprType exprType = OpenSearchTypeFactory.convertRelDataTypeToExprType(groupType);
        if (List.of(ExprCoreType.TIMESTAMP, ExprCoreType.TIME, ExprCoreType.DATE).contains(exprType)) {
            return withValueTypeHint.apply(ValueType.LONG);
        }
        if (isSourceField) {
            return sourceBuilder;
        }
        ValueType valueType = ValueType.lenientParse((String)exprType.typeName().toLowerCase());
        return valueType == null || valueType == ValueType.STRING ? sourceBuilder : withValueTypeHint.apply(valueType);
    }

    public static class AggregateBuilderHelper {
        final RelDataType rowType;
        final Map<String, ExprType> fieldTypes;
        final RelOptCluster cluster;
        final boolean bucketNullable;
        final int bucketSize;

        <T extends ValuesSourceAggregationBuilder<T>> T build(RexNode node, T aggBuilder) {
            return (T)this.build(node, arg_0 -> aggBuilder.field(arg_0), arg_0 -> aggBuilder.script(arg_0));
        }

        <T extends CompositeValuesSourceBuilder<T>> T build(RexNode node, T sourceBuilder) {
            return (T)this.build(node, arg_0 -> sourceBuilder.field(arg_0), arg_0 -> sourceBuilder.script(arg_0));
        }

        <T> T build(RexNode node, Function<String, T> fieldBuilder, Function<Script, T> scriptBuilder) {
            if (node == null) {
                return fieldBuilder.apply(AggregateAnalyzer.METADATA_FIELD);
            }
            if (node instanceof RexInputRef) {
                RexInputRef ref = (RexInputRef)node;
                return fieldBuilder.apply(this.inferNamedField(node).getReferenceForTermQuery());
            }
            if (node instanceof RexCall || node instanceof RexLiteral) {
                return scriptBuilder.apply(this.inferScript(node).getScript());
            }
            throw new IllegalStateException(String.format("Metric aggregation doesn't support RexNode %s", node));
        }

        PredicateAnalyzer.NamedFieldExpression inferNamedField(RexNode node) {
            if (node instanceof RexInputRef) {
                RexInputRef ref = (RexInputRef)node;
                return new PredicateAnalyzer.NamedFieldExpression(ref.getIndex(), (List<String>)this.rowType.getFieldNames(), this.fieldTypes);
            }
            throw new IllegalStateException(String.format("Cannot infer field name from RexNode %s", node));
        }

        PredicateAnalyzer.ScriptQueryExpression inferScript(RexNode node) {
            if (node instanceof RexCall || node instanceof RexLiteral) {
                return new PredicateAnalyzer.ScriptQueryExpression(node, this.rowType, this.fieldTypes, this.cluster, Collections.emptyMap());
            }
            throw new IllegalStateException(String.format("Metric aggregation doesn't support RexNode %s", node));
        }

        <T> T inferValue(RexNode node, Class<T> clazz) {
            if (node instanceof RexLiteral) {
                RexLiteral literal = (RexLiteral)node;
                return (T)literal.getValueAs(clazz);
            }
            throw new IllegalStateException(String.format("Cannot infer value from RexNode %s", node));
        }

        @Generated
        public AggregateBuilderHelper(RelDataType rowType, Map<String, ExprType> fieldTypes, RelOptCluster cluster, boolean bucketNullable, int bucketSize) {
            this.rowType = rowType;
            this.fieldTypes = fieldTypes;
            this.cluster = cluster;
            this.bucketNullable = bucketNullable;
            this.bucketSize = bucketSize;
        }
    }

    public static class ExpressionNotAnalyzableException
    extends Exception {
        ExpressionNotAnalyzableException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static final class AggregateAnalyzerException
    extends RuntimeException {
        AggregateAnalyzerException(String message) {
            super(message);
        }

        AggregateAnalyzerException(Throwable cause) {
            super(cause);
        }
    }
}

