/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.ErrorMessageType;
import com.networknt.schema.Format;
import com.networknt.schema.FormatValidator;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.Keyword;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidatorTypeCode;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class FormatKeyword
implements Keyword {
    private final String value;
    private final ErrorMessageType errorMessageType;
    private final Map<String, Format> formats;

    public FormatKeyword(Map<String, Format> formats) {
        this(ValidatorTypeCode.FORMAT, formats);
    }

    public FormatKeyword(ValidatorTypeCode type, Map<String, Format> formats) {
        this(type.getValue(), type, formats);
    }

    public FormatKeyword(String value, ErrorMessageType errorMessageType, Map<String, Format> formats) {
        this.value = value;
        this.formats = formats;
        this.errorMessageType = errorMessageType;
    }

    Collection<Format> getFormats() {
        return Collections.unmodifiableCollection(this.formats.values());
    }

    @Override
    public JsonValidator newValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        Format format = null;
        if (schemaNode != null && schemaNode.isTextual()) {
            String formatName = schemaNode.textValue();
            format = this.formats.get(formatName);
        }
        return new FormatValidator(schemaLocation, evaluationPath, schemaNode, parentSchema, validationContext, format, this.errorMessageType, this);
    }

    @Override
    public String getValue() {
        return this.value;
    }
}

