/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.navbar.frontend.actions;

import com.intellij.platform.navbar.frontend.actions.NavBarActionHandler;
import com.intellij.platform.navbar.frontend.vm.NavBarPopupVm;
import com.intellij.platform.navbar.frontend.vm.NavBarVm;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\b \u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\u0007H\u0016J\b\u0010\n\u001a\u00020\u0007H\u0016J\b\u0010\u000b\u001a\u00020\u0007H\u0016J\b\u0010\f\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/platform/navbar/frontend/actions/NavBarActionHandlerImpl;", "Lcom/intellij/platform/navbar/frontend/actions/NavBarActionHandler;", "vm", "Lcom/intellij/platform/navbar/frontend/vm/NavBarVm;", "<init>", "(Lcom/intellij/platform/navbar/frontend/vm/NavBarVm;)V", "moveHome", "", "moveLeft", "moveRight", "moveEnd", "moveUpDown", "enter", "intellij.platform.navbar.frontend"})
public abstract class NavBarActionHandlerImpl
implements NavBarActionHandler {
    @NotNull
    private final NavBarVm vm;

    public NavBarActionHandlerImpl(@NotNull NavBarVm vm) {
        Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
        this.vm = vm;
    }

    @Override
    public void moveHome() {
        this.vm.shiftSelectionTo(NavBarVm.SelectionShift.FIRST);
    }

    @Override
    public void moveLeft() {
        this.vm.shiftSelectionTo(NavBarVm.SelectionShift.PREV);
    }

    @Override
    public void moveRight() {
        this.vm.shiftSelectionTo(NavBarVm.SelectionShift.NEXT);
    }

    @Override
    public void moveEnd() {
        this.vm.shiftSelectionTo(NavBarVm.SelectionShift.LAST);
    }

    @Override
    public void moveUpDown() {
        this.vm.showPopup();
    }

    @Override
    public void enter() {
        NavBarPopupVm navBarPopupVm = (NavBarPopupVm)this.vm.getPopup().getValue();
        if (navBarPopupVm != null) {
            navBarPopupVm.complete();
        } else {
            this.vm.showPopup();
        }
    }
}

