/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.VcsInternalDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.FileHistoryPanelImpl;
import com.intellij.openapi.vcs.history.FileHistoryRefresherI;
import com.intellij.openapi.vcs.history.LimitHistoryCheck;
import com.intellij.openapi.vcs.history.VcsAbstractHistorySession;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsHistorySessionConsumer;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.BufferedListConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.ContentUtilEx;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class FileHistorySessionPartner
implements VcsHistorySessionConsumer,
Disposable {
    @NotNull
    private final AbstractVcs myVcs;
    @NotNull
    private final VcsHistoryProvider myVcsHistoryProvider;
    @NotNull
    private final FilePath myPath;
    @Nullable
    private final VcsRevisionNumber myStartingRevisionNumber;
    @NotNull
    private final FileHistoryRefresherI myRefresher;
    @NotNull
    private final LimitHistoryCheck myLimitHistoryCheck;
    @NotNull
    private final BufferedListConsumer<VcsFileRevision> myBuffer;
    @NotNull
    private final FileHistoryContentPanel myContentPanel;
    private volatile VcsAbstractHistorySession mySession;

    public FileHistorySessionPartner(@NotNull VcsHistoryProvider vcsHistoryProvider, @NotNull FilePath path, @Nullable VcsRevisionNumber startingRevisionNumber, @NotNull AbstractVcs vcs, @NotNull FileHistoryRefresherI refresher) {
        if (vcsHistoryProvider == null) {
            FileHistorySessionPartner.$$$reportNull$$$0(0);
        }
        if (path == null) {
            FileHistorySessionPartner.$$$reportNull$$$0(1);
        }
        if (vcs == null) {
            FileHistorySessionPartner.$$$reportNull$$$0(2);
        }
        if (refresher == null) {
            FileHistorySessionPartner.$$$reportNull$$$0(3);
        }
        this.mySession = null;
        this.myVcsHistoryProvider = vcsHistoryProvider;
        this.myPath = path;
        this.myStartingRevisionNumber = startingRevisionNumber;
        this.myRefresher = refresher;
        this.myLimitHistoryCheck = new LimitHistoryCheck(vcs.getProject(), path.getPath());
        this.myVcs = vcs;
        this.myContentPanel = new FileHistoryContentPanel();
        Consumer sessionRefresher = vcsFileRevisions -> {
            this.mySession.getRevisionList().addAll(vcsFileRevisions);
            VcsHistorySession copy = this.mySession.copyWithCachedRevision();
            ApplicationManager.getApplication().invokeLater(() -> this.myContentPanel.setHistorySession(copy), o -> Disposer.isDisposed((Disposable)this));
        };
        this.myBuffer = new BufferedListConsumer<VcsFileRevision>(this, 5, sessionRefresher, 1000){

            protected void invokeConsumer(@NotNull Runnable consumerRunnable) {
                if (consumerRunnable == null) {
                    1.$$$reportNull$$$0(0);
                }
                consumerRunnable.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumerRunnable", "com/intellij/openapi/vcs/history/FileHistorySessionPartner$1", "invokeConsumer"));
            }
        };
    }

    @Nullable
    static FileHistoryRefresherI findExistingHistoryRefresher(@NotNull Project project, @NotNull FilePath path, @Nullable VcsRevisionNumber startingRevisionNumber) {
        JComponent component;
        if (project == null) {
            FileHistorySessionPartner.$$$reportNull$$$0(4);
        }
        if (path == null) {
            FileHistorySessionPartner.$$$reportNull$$$0(5);
        }
        if ((component = ContentUtilEx.findContentComponent((ContentManager)FileHistorySessionPartner.getToolWindow(project).getContentManager(), comp -> comp instanceof FileHistoryContentPanel && FileHistoryPanelImpl.sameHistories(((FileHistoryContentPanel)((Object)((Object)comp))).getPath(), ((FileHistoryContentPanel)((Object)((Object)comp))).getRevision(), path, startingRevisionNumber))) == null) {
            return null;
        }
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)component);
        return (FileHistoryRefresherI)VcsInternalDataKeys.FILE_HISTORY_REFRESHER.getData(dataContext);
    }

    @RequiresBackgroundThread
    public boolean shouldBeRefreshed() {
        return this.mySession.shouldBeRefreshed();
    }

    public void acceptRevision(VcsFileRevision revision) {
        this.myLimitHistoryCheck.checkNumber();
        this.myBuffer.consumeOne((Object)revision);
    }

    public void reportCreatedEmptySession(VcsAbstractHistorySession session) {
        if (this.mySession != null && session != null && this.mySession.getRevisionList().equals(session.getRevisionList())) {
            return;
        }
        this.mySession = session;
        if (this.mySession != null) {
            this.mySession.shouldBeRefreshed();
            List revisionList = this.mySession.getRevisionList();
            while (this.myLimitHistoryCheck.isOver(revisionList.size())) {
                revisionList.remove(revisionList.size() - 1);
            }
        }
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (this.mySession != null) {
                this.myContentPanel.setHistorySession(this.mySession.copyWithCachedRevision());
            }
        });
    }

    @NotNull
    private static ToolWindow getToolWindow(@NotNull Project project) {
        if (project == null) {
            FileHistorySessionPartner.$$$reportNull$$$0(6);
        }
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow("Version Control");
        assert (toolWindow != null) : "Version Control ToolWindow should be available at this point.";
        ToolWindow toolWindow2 = toolWindow;
        if (toolWindow2 == null) {
            FileHistorySessionPartner.$$$reportNull$$$0(7);
        }
        return toolWindow2;
    }

    public void reportException(VcsException exception) {
        VcsBalloonProblemNotifier.showOverVersionControlView(this.myVcs.getProject(), VcsBundle.message((String)"message.title.could.not.load.file.history", (Object[])new Object[0]) + ": " + exception.getMessage(), MessageType.ERROR);
    }

    public void beforeRefresh() {
        this.myLimitHistoryCheck.reset();
    }

    public void createOrSelectContent() {
        ToolWindow toolWindow = FileHistorySessionPartner.getToolWindow(this.myVcs.getProject());
        ContentManager manager = toolWindow.getContentManager();
        boolean selectedExistingContent = ContentUtilEx.selectContent((ContentManager)manager, (JComponent)((Object)this.myContentPanel), (boolean)true);
        if (!selectedExistingContent) {
            String tabName = FileHistorySessionPartner.getTabName(this.myPath, this.myStartingRevisionNumber);
            ContentUtilEx.addTabbedContent((ContentManager)manager, (JComponent)((Object)this.myContentPanel), (String)"History", (Supplier)VcsBundle.messagePointer((String)"file.history.tab.name", (Object[])new Object[0]), () -> tabName, (boolean)true, (Disposable)this);
        }
        toolWindow.activate(null);
    }

    @NlsContexts.TabTitle
    @NotNull
    private static String getTabName(@NotNull FilePath path, @Nullable VcsRevisionNumber revisionNumber) {
        if (path == null) {
            FileHistorySessionPartner.$$$reportNull$$$0(8);
        }
        Object tabName = path.getName();
        if (revisionNumber != null) {
            tabName = (String)tabName + " (" + VcsUtil.getShortRevisionString((VcsRevisionNumber)revisionNumber) + ")";
        }
        String string = tabName;
        if (string == null) {
            FileHistorySessionPartner.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    public void finished() {
        this.myBuffer.flush();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (this.mySession == null) {
                return;
            }
            this.myContentPanel.finishRefresh();
        });
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsHistoryProvider";
                break;
            }
            case 1: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refresher";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/history/FileHistorySessionPartner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/history/FileHistorySessionPartner";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWindow";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findExistingHistoryRefresher";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getToolWindow";
                break;
            }
            case 7: 
            case 9: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTabName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 9 -> new IllegalStateException(string);
        };
    }

    private final class FileHistoryContentPanel
    extends JBPanelWithEmptyText {
        @Nullable
        private FileHistoryPanelImpl myFileHistoryPanel;

        private FileHistoryContentPanel() {
            super((LayoutManager)new BorderLayout());
            String text = FileHistorySessionPartner.this.myStartingRevisionNumber != null ? VcsBundle.message((String)"loading.file.history.up.to.revision.status", (Object[])new Object[]{FileHistorySessionPartner.this.myPath.getName(), VcsUtil.getShortRevisionString((VcsRevisionNumber)FileHistorySessionPartner.this.myStartingRevisionNumber)}) : VcsBundle.message((String)"loading.file.history.status", (Object[])new Object[]{FileHistorySessionPartner.this.myPath.getName()});
            this.withEmptyText(text);
        }

        public void setHistorySession(@NotNull VcsHistorySession session) {
            if (session == null) {
                FileHistoryContentPanel.$$$reportNull$$$0(0);
            }
            if (this.myFileHistoryPanel == null) {
                this.myFileHistoryPanel = new FileHistoryPanelImpl(FileHistorySessionPartner.this.myVcs, FileHistorySessionPartner.this.myPath, FileHistorySessionPartner.this.myStartingRevisionNumber, session, FileHistorySessionPartner.this.myVcsHistoryProvider, FileHistorySessionPartner.this.myRefresher, false);
                this.add(this.myFileHistoryPanel, "Center");
                Disposer.register((Disposable)FileHistorySessionPartner.this, (Disposable)this.myFileHistoryPanel);
            } else if (!session.getRevisionList().isEmpty()) {
                this.myFileHistoryPanel.setHistorySession(session);
            }
        }

        public void finishRefresh() {
            if (this.myFileHistoryPanel != null) {
                this.myFileHistoryPanel.finishRefresh();
            }
        }

        @NotNull
        public FilePath getPath() {
            FilePath filePath = FileHistorySessionPartner.this.myPath;
            if (filePath == null) {
                FileHistoryContentPanel.$$$reportNull$$$0(1);
            }
            return filePath;
        }

        @Nullable
        public VcsRevisionNumber getRevision() {
            return FileHistorySessionPartner.this.myStartingRevisionNumber;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/history/FileHistorySessionPartner$FileHistoryContentPanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/history/FileHistorySessionPartner$FileHistoryContentPanel";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setHistorySession";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

