/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.testdb;

import java.io.BufferedReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import schemacrawler.testdb.IOUtility;

public class TestSchemaCreator
implements Runnable {
    private final Connection connection;
    private final String scriptsResource;

    private static void executeScriptLine(String scriptResourceLine, Connection connection) {
        String delimiter;
        String scriptResource;
        Objects.requireNonNull(scriptResourceLine, "No script resource line provided");
        Objects.requireNonNull(connection, "No database connection provided");
        String[] split = scriptResourceLine.split(",");
        if (split.length == 1) {
            scriptResource = scriptResourceLine.strip();
            delimiter = scriptResource.isEmpty() ? "#" : ";";
        } else if (split.length == 2) {
            delimiter = split[0].strip();
            scriptResource = split[1].strip();
        } else {
            throw new RuntimeException("Too many fields in \"%s\"".formatted(scriptResourceLine));
        }
        boolean skip = "#".equals(delimiter);
        if (skip) {
            return;
        }
        try (BufferedReader scriptReader = IOUtility.newResourceReader(scriptResource);){
            TestSchemaCreator.executeSqlScript(connection, scriptReader, delimiter);
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException("Could not read \"%s\"".formatted(scriptResource), e);
        }
    }

    private static void executeSqlScript(Connection connection, BufferedReader reader, String delimiter) throws IOException, SQLException {
        String[] statements;
        String line;
        StringBuilder scriptBuilder = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            scriptBuilder.append(line).append("\n");
        }
        String fixedDelimiter = "@".equals(delimiter) ? "\\R@" : delimiter;
        for (String stmt : statements = scriptBuilder.toString().split(fixedDelimiter)) {
            String sql = stmt.strip();
            if (sql.isBlank()) continue;
            try (Statement statement = connection.createStatement();){
                statement.execute(sql);
            }
        }
    }

    public TestSchemaCreator(Connection connection, String scriptsResource, boolean debug) {
        this.connection = Objects.requireNonNull(connection, "No database connection provided");
        this.scriptsResource = Objects.requireNonNull(scriptsResource, "No script resource provided");
    }

    @Override
    public void run() {
        try (BufferedReader reader = IOUtility.newResourceReader(this.scriptsResource);){
            reader.lines().forEach(line -> TestSchemaCreator.executeScriptLine(line, this.connection));
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

