/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.util.Objects;
import java.util.concurrent.locks.Lock;
import org.apache.tomcat.util.net.SocketEvent;
import org.apache.tomcat.util.net.SocketWrapperBase;

public abstract class SocketProcessorBase<S>
implements Runnable {
    protected SocketWrapperBase<S> socketWrapper;
    protected SocketEvent event;

    public SocketProcessorBase(SocketWrapperBase<S> socketWrapperBase, SocketEvent socketEvent) {
        this.reset(socketWrapperBase, socketEvent);
    }

    public void reset(SocketWrapperBase<S> socketWrapperBase, SocketEvent socketEvent) {
        Objects.requireNonNull(socketEvent);
        this.socketWrapper = socketWrapperBase;
        this.event = socketEvent;
    }

    @Override
    public final void run() {
        Lock lock = this.socketWrapper.getLock();
        lock.lock();
        try {
            if (this.socketWrapper.isClosed()) {
                return;
            }
            this.doRun();
        }
        finally {
            lock.unlock();
        }
    }

    protected abstract void doRun();
}

