---
stage: none
group: unassigned
info: For assistance with this Style Guide page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments-to-other-projects-and-subjects.
title: Automated pages
---

Most pages in the GitLab documentation are written manually in Markdown.
However, some pages are created by automated processes.

Two primary categories of automation exist in the GitLab documentation:

- Content that is generated by using a standard process and structured data (for example, YAML or JSON files).
- Content that is generated by any other means.

Automation helps with consistency and speed. But content that is automated in a
non-standard way causes difficulty with:

- Frontend changes.
- Site troubleshooting and maintenance.
- The contributor experience.

Ideally, any automation should be done in a standard way, which helps alleviate some of the downsides.

## Pages generated from structured data

Some functionality on the docs site uses structured data:

- Hierarchical global navigation (YAML)
- Survey banner (YAML)
- Badges (YAML)
- Homepage content lists (YAML)
- Redirects (YAML)
- Versions menu (JSON)

## Pages generated otherwise

Other pages are generated by using non-standard processes. These pages often use solutions
that are coded across multiple repositories.

| Page | Details | Owner |
|------|---------|-------|
| [All feature flags in GitLab](../../../administration/feature_flags/list.md) | [Generated during docs build](https://gitlab.com/gitlab-org/gitlab-docs/-/blob/main/doc/raketasks.md#generate-the-feature-flag-tables) | [Technical Writing](https://handbook.gitlab.com/handbook/product/ux/technical-writing/) |
| [GitLab Runner feature flags](https://docs.gitlab.com/runner/configuration/feature-flags.html) | [Page source](https://gitlab.com/gitlab-org/gitlab-runner/-/blob/ec6e1797d2173a95c8ac7f726bd62f6f110b7211/docs/configuration/feature-flags.md?plain=1#L39) | [Runner](https://handbook.gitlab.com/handbook/engineering/development/ops/verify/runner/) |
| [GitLab Runner Kubernetes API settings](https://docs.gitlab.com/runner/executors/kubernetes/) | Generated with [mage](https://gitlab.com/gitlab-org/gitlab-runner/-/blob/main/.gitlab/ci/qa.gitlab-ci.yml#L133) | [Runner](https://handbook.gitlab.com/handbook/engineering/development/ops/verify/runner/) |
| [Deprecations and removals by version](../../../update/deprecations.md) | [Update the deprecations and removals documentation](../../deprecation_guidelines/_index.md#update-the-deprecations-and-removals-documentation) |  |
| [Breaking change windows](../../../update/breaking_windows.md) | [Update the breaking change windows documentation](../../deprecation_guidelines/_index.md#update-the-breaking-change-windows-documentation) |  |
| [GraphQL API resources](../../../api/graphql/reference/_index.md) | [GraphQL API style guide](../../api_graphql_styleguide.md#documentation-and-schema) | [Import and Integrate](https://handbook.gitlab.com/handbook/engineering/development/dev/foundations/import-and-integrate/) |
| [REST API OpenAPI V2 documentation](https://gitlab.com/gitlab-org/gitlab/-/blob/master/doc/api/openapi/openapi_v2.yaml) | [Documenting REST API resources](../restful_api_styleguide.md) | [Import and Integrate](https://handbook.gitlab.com/handbook/engineering/development/dev/foundations/import-and-integrate/) |
| [Audit event types](../../../user/compliance/audit_event_types.md) | [Audit event development guidelines](../../audit_event_guide/_index.md) | [Compliance](https://handbook.gitlab.com/handbook/engineering/development/sec/govern/compliance/) |
| [Available custom role permissions](../../../user/custom_roles/abilities.md) | [Generated by Rake task](https://gitlab.com/gitlab-org/gitlab/-/blob/master/tooling/custom_roles/docs/templates/custom_abilities.md.erb) | [Authorization](https://handbook.gitlab.com/handbook/product/categories/#authorization-group)|
| [CI/CD Job token fine-grained permissions](../../../ci/jobs/fine_grained_permissions.md) | [Generated by Rake task](https://gitlab.com/gitlab-org/gitlab/-/blob/master/tooling/ci/job_tokens/docs/templates/fine_grained_permissions.md.erb) | [Authorization](https://handbook.gitlab.com/handbook/product/categories/#authorization-group)|
| [Application settings analysis](../../cells/application_settings_analysis.md) | [Generated by Ruby script](https://gitlab.com/gitlab-org/gitlab/-/blob/2bb2910c84fad965bde473aa2881d88358b6e96e/scripts/cells/application-settings-analysis.rb#L353) | |
| DAST vulnerability check documentation ([Example](../../../user/application_security/dast/browser/checks/798.140.md)) | [How to generate the Markdown](https://gitlab.com/gitlab-org/security-products/dast-cwe-checks/-/blob/main/doc/how-to-generate-the-markdown-documentation.md) | [Dynamic Analysis](https://handbook.gitlab.com/handbook/product/categories/#dynamic-analysis-group) |
| [The docs homepage](../../../_index.md) |  | [Technical Writing](https://handbook.gitlab.com/handbook/product/ux/technical-writing/) |
| [Version mappings table](https://docs.gitlab.com/charts/installation/version_mappings/#previous-chart-versions) on the Helm chart versions page | Managed by a [script](https://gitlab.com/gitlab-org/release-tools/-/blob/master/lib/release_tools/helm/version_mapping.rb) in `release-tools` | [Release tools](https://handbook.gitlab.com/handbook/engineering/infrastructure-platforms/release-tools/) |

## Make an automation request

If you want to automate a page on the docs site:

1. Review [issue 246](https://gitlab.com/gitlab-org/technical-writing/docs-gitlab-com/-/issues/246)
   and consider adding feedback there.
1. If that issue does not describe what you need, contact
   [the DRI for the docs site backend](https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments-to-other-projects-and-subjects).

Because automation adds extra complexity and a support burden, we
review it on a case-by-case basis.

## Document the automation

If you do add automation, you must document:

- The list of files that are included.
- The `.gitlab-ci.yml` updates and any pipeline requirements.
- The steps needed to troubleshoot.

Other GitLab team members should be able to easily find information about how to maintain the automation.
You should announce the change widely, including, at a minimum:

- In Slack, in `#whats-happening-at-gitlab`.
- In the Technical Writer team meeting agenda.
