/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.core.trace.impl.interpret;

import com.intellij.debugger.streams.core.trace.ArrayReference;
import com.intellij.debugger.streams.core.trace.CallTraceInterpreter;
import com.intellij.debugger.streams.core.trace.IntegerValue;
import com.intellij.debugger.streams.core.trace.TraceElement;
import com.intellij.debugger.streams.core.trace.TraceInfo;
import com.intellij.debugger.streams.core.trace.Value;
import com.intellij.debugger.streams.core.trace.impl.TraceElementImpl;
import com.intellij.debugger.streams.core.trace.impl.interpret.ValuesOrderInfo;
import com.intellij.debugger.streams.core.trace.impl.interpret.ex.UnexpectedValueException;
import com.intellij.debugger.streams.core.wrapper.StreamCall;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimplePeekCallTraceInterpreter
implements CallTraceInterpreter {
    @Override
    @NotNull
    public TraceInfo resolve(@NotNull StreamCall call, @NotNull Value value) {
        if (call == null) {
            SimplePeekCallTraceInterpreter.$$$reportNull$$$0(0);
        }
        if (value == null) {
            SimplePeekCallTraceInterpreter.$$$reportNull$$$0(1);
        }
        if (value instanceof ArrayReference) {
            ArrayReference trace2 = (ArrayReference)value;
            Value before = trace2.getValue(0);
            Value after = trace2.getValue(1);
            if (before instanceof ArrayReference && after instanceof ArrayReference) {
                Map<Integer, TraceElement> beforeTrace = SimplePeekCallTraceInterpreter.resolveTrace((ArrayReference)before);
                Map<Integer, TraceElement> afterTrace = SimplePeekCallTraceInterpreter.resolveTrace((ArrayReference)after);
                return new ValuesOrderInfo(call, beforeTrace, afterTrace);
            }
        }
        throw new UnexpectedValueException("peek operation trace is wrong format");
    }

    @NotNull
    protected static Map<Integer, TraceElement> resolveTrace(@NotNull ArrayReference mapArray) {
        if (mapArray == null) {
            SimplePeekCallTraceInterpreter.$$$reportNull$$$0(2);
        }
        Value keys = mapArray.getValue(0);
        Value values = mapArray.getValue(1);
        if (keys instanceof ArrayReference && values instanceof ArrayReference) {
            return SimplePeekCallTraceInterpreter.resolveTrace((ArrayReference)keys, (ArrayReference)values);
        }
        throw new UnexpectedValueException("keys and values must be stored in arrays in peek resolver");
    }

    @NotNull
    private static Map<Integer, TraceElement> resolveTrace(@NotNull ArrayReference keysArray, @NotNull ArrayReference valuesArray) {
        if (keysArray == null) {
            SimplePeekCallTraceInterpreter.$$$reportNull$$$0(3);
        }
        if (valuesArray == null) {
            SimplePeekCallTraceInterpreter.$$$reportNull$$$0(4);
        }
        LinkedHashMap<Integer, TraceElement> result = new LinkedHashMap<Integer, TraceElement>();
        if (keysArray.length() == valuesArray.length()) {
            int size = keysArray.length();
            for (int i = 0; i < size; ++i) {
                TraceElement element = SimplePeekCallTraceInterpreter.resolveTraceElement(keysArray.getValue(i), valuesArray.getValue(i));
                result.put(element.getTime(), element);
            }
            LinkedHashMap<Integer, TraceElement> linkedHashMap = result;
            if (linkedHashMap == null) {
                SimplePeekCallTraceInterpreter.$$$reportNull$$$0(5);
            }
            return linkedHashMap;
        }
        throw new UnexpectedValueException("keys and values arrays should be with the same sizes");
    }

    @NotNull
    private static TraceElement resolveTraceElement(@NotNull Value key, @Nullable Value value) {
        if (key == null) {
            SimplePeekCallTraceInterpreter.$$$reportNull$$$0(6);
        }
        if (key instanceof IntegerValue) {
            return new TraceElementImpl(((IntegerValue)key).value(), value);
        }
        throw new UnexpectedValueException("key must be an integer value");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapArray";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keysArray";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valuesArray";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/streams/core/trace/impl/interpret/SimplePeekCallTraceInterpreter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/streams/core/trace/impl/interpret/SimplePeekCallTraceInterpreter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveTrace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolveTrace";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveTraceElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

