/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.memory.Universe;
import sun.jvm.hotspot.oops.ArrayKlass;
import sun.jvm.hotspot.oops.ObjectHeap;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.OopVisitor;
import sun.jvm.hotspot.runtime.BasicType;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;

public class Array
extends Oop {
    private static long headerSize;
    private static long lengthOffsetInBytes;
    private static long typeSize;

    Array(OopHandle handle, ObjectHeap heap) {
        super(handle, heap);
    }

    private static void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("arrayOopDesc");
        typeSize = (int)type.getSize();
    }

    private static long headerSizeInBytes() {
        if (headerSize != 0L) {
            return headerSize;
        }
        headerSize = VM.getVM().isCompressedKlassPointersEnabled() ? typeSize : VM.getVM().alignUp(typeSize + VM.getVM().getIntSize(), VM.getVM().getHeapWordSize());
        return headerSize;
    }

    private static long headerSize(BasicType type) {
        if (Universe.elementTypeShouldBeAligned(type)) {
            return Array.alignObjectSize(Array.headerSizeInBytes()) / (long)VM.getVM().getHeapWordSize();
        }
        return Array.headerSizeInBytes() / (long)VM.getVM().getHeapWordSize();
    }

    private long lengthOffsetInBytes() {
        if (lengthOffsetInBytes != 0L) {
            return lengthOffsetInBytes;
        }
        lengthOffsetInBytes = VM.getVM().isCompressedKlassPointersEnabled() ? typeSize - VM.getVM().getIntSize() : typeSize;
        return lengthOffsetInBytes;
    }

    public long getLength() {
        boolean isUnsigned = true;
        return this.getHandle().getCIntegerAt(this.lengthOffsetInBytes(), VM.getVM().getIntSize(), isUnsigned);
    }

    @Override
    public long getObjectSize() {
        ArrayKlass klass = (ArrayKlass)this.getKlass();
        long s = this.getLength() << klass.getLog2ElementSize();
        s += klass.getArrayHeaderInBytes();
        s = Oop.alignObjectSize(s);
        return s;
    }

    public static long baseOffsetInBytes(BasicType type) {
        return Array.headerSize(type) * (long)VM.getVM().getHeapWordSize();
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public void iterateFields(OopVisitor visitor, boolean doVMFields) {
        super.iterateFields(visitor, doVMFields);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                Array.initialize(VM.getVM().getTypeDataBase());
            }
        });
        headerSize = 0L;
        lengthOffsetInBytes = 0L;
    }
}

