/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.Font;
import java.awt.font.CharArrayIterator;
import java.awt.font.FontRenderContext;
import java.awt.font.GraphicAttribute;
import java.awt.font.LineMetrics;
import java.awt.font.NumericShaper;
import java.awt.font.StyledParagraph;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.font.TextLine;
import java.text.AttributedCharacterIterator;
import java.text.Bidi;
import java.text.BreakIterator;
import java.util.Hashtable;
import java.util.Map;
import sun.font.AttributeValues;
import sun.font.BidiUtils;
import sun.font.TextLabelFactory;
import sun.font.TextLineComponent;

public final class TextMeasurer
implements Cloneable {
    private static float EST_LINES = 2.1f;
    private FontRenderContext fFrc;
    private int fStart;
    private char[] fChars;
    private Bidi fBidi;
    private byte[] fLevels;
    private TextLineComponent[] fComponents;
    private int fComponentStart;
    private int fComponentLimit;
    private boolean haveLayoutWindow;
    private BreakIterator fLineBreak = null;
    private CharArrayIterator charIter = null;
    int layoutCount = 0;
    int layoutCharCount = 0;
    private StyledParagraph fParagraph;
    private boolean fIsDirectionLTR;
    private byte fBaseline;
    private float[] fBaselineOffsets;
    private float fJustifyRatio = 1.0f;
    private int formattedChars = 0;
    private static boolean wantStats = false;
    private boolean collectStats = false;

    public TextMeasurer(AttributedCharacterIterator attributedCharacterIterator, FontRenderContext fontRenderContext) {
        this.fFrc = fontRenderContext;
        this.initAll(attributedCharacterIterator);
    }

    protected Object clone() {
        TextMeasurer textMeasurer;
        try {
            textMeasurer = (TextMeasurer)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error();
        }
        if (this.fComponents != null) {
            textMeasurer.fComponents = (TextLineComponent[])this.fComponents.clone();
        }
        return textMeasurer;
    }

    private void invalidateComponents() {
        this.fComponentStart = this.fComponentLimit = this.fChars.length;
        this.fComponents = null;
        this.haveLayoutWindow = false;
    }

    private void initAll(AttributedCharacterIterator attributedCharacterIterator) {
        this.fStart = attributedCharacterIterator.getBeginIndex();
        this.fChars = new char[attributedCharacterIterator.getEndIndex() - this.fStart];
        int n = 0;
        char c = attributedCharacterIterator.first();
        while (c != '\uffff') {
            this.fChars[n++] = c;
            c = attributedCharacterIterator.next();
        }
        attributedCharacterIterator.first();
        this.fBidi = new Bidi(attributedCharacterIterator);
        if (this.fBidi.isLeftToRight()) {
            this.fBidi = null;
        }
        attributedCharacterIterator.first();
        Map<AttributedCharacterIterator.Attribute, Object> map = attributedCharacterIterator.getAttributes();
        NumericShaper numericShaper = AttributeValues.getNumericShaping(map);
        if (numericShaper != null) {
            numericShaper.shape(this.fChars, 0, this.fChars.length);
        }
        this.fParagraph = new StyledParagraph(attributedCharacterIterator, this.fChars);
        this.fJustifyRatio = AttributeValues.getJustification(map);
        boolean bl = TextLine.advanceToFirstFont(attributedCharacterIterator);
        if (bl) {
            Font font = TextLine.getFontAtCurrentPos(attributedCharacterIterator);
            int n2 = attributedCharacterIterator.getIndex() - attributedCharacterIterator.getBeginIndex();
            LineMetrics lineMetrics = font.getLineMetrics(this.fChars, n2, n2 + 1, this.fFrc);
            this.fBaseline = (byte)lineMetrics.getBaselineIndex();
            this.fBaselineOffsets = lineMetrics.getBaselineOffsets();
        } else {
            GraphicAttribute graphicAttribute = (GraphicAttribute)map.get(TextAttribute.CHAR_REPLACEMENT);
            this.fBaseline = TextLayout.getBaselineFromGraphic(graphicAttribute);
            Hashtable hashtable = new Hashtable(5, 0.9f);
            Font font = new Font(hashtable);
            LineMetrics lineMetrics = font.getLineMetrics(" ", 0, 1, this.fFrc);
            this.fBaselineOffsets = lineMetrics.getBaselineOffsets();
        }
        this.fBaselineOffsets = TextLine.getNormalizedOffsets(this.fBaselineOffsets, this.fBaseline);
        this.invalidateComponents();
    }

    private void generateComponents(int n, int n2) {
        if (this.collectStats) {
            this.formattedChars += n2 - n;
        }
        int n3 = 0;
        TextLabelFactory textLabelFactory = new TextLabelFactory(this.fFrc, this.fChars, this.fBidi, n3);
        int[] nArray = null;
        if (this.fBidi != null) {
            this.fLevels = BidiUtils.getLevels(this.fBidi);
            int[] nArray2 = BidiUtils.createVisualToLogicalMap(this.fLevels);
            nArray = BidiUtils.createInverseMap(nArray2);
            this.fIsDirectionLTR = this.fBidi.baseIsLeftToRight();
        } else {
            this.fLevels = null;
            this.fIsDirectionLTR = true;
        }
        try {
            this.fComponents = TextLine.getComponents(this.fParagraph, this.fChars, n, n2, nArray, this.fLevels, textLabelFactory);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("startingAt=" + n + "; endingAt=" + n2);
            System.out.println("fComponentLimit=" + this.fComponentLimit);
            throw illegalArgumentException;
        }
        this.fComponentStart = n;
        this.fComponentLimit = n2;
    }

    private int calcLineBreak(int n, float f) {
        int n2;
        int n3;
        int n4 = n;
        float f2 = f;
        int n5 = this.fComponentStart;
        for (n3 = 0; n3 < this.fComponents.length && (n2 = n5 + this.fComponents[n3].getNumCharacters()) <= n4; ++n3) {
            n5 = n2;
        }
        while (n3 < this.fComponents.length) {
            TextLineComponent textLineComponent = this.fComponents[n3];
            int n6 = textLineComponent.getNumCharacters();
            int n7 = textLineComponent.getLineBreakIndex(n4 - n5, f2);
            if (n7 == n6 && n3 < this.fComponents.length) {
                f2 -= textLineComponent.getAdvanceBetween(n4 - n5, n7);
            } else {
                return n5 + n7;
            }
            n4 = n5 += n6;
            ++n3;
        }
        if (this.fComponentLimit < this.fChars.length) {
            this.generateComponents(n, this.fChars.length);
            return this.calcLineBreak(n, f);
        }
        return this.fChars.length;
    }

    private int trailingCdWhitespaceStart(int n, int n2) {
        if (this.fLevels != null) {
            byte by = (byte)(!this.fIsDirectionLTR ? 1 : 0);
            int n3 = n2;
            while (--n3 >= n) {
                if (this.fLevels[n3] % 2 != by && Character.getDirectionality(this.fChars[n3]) == 12) continue;
                return ++n3;
            }
        }
        return n;
    }

    private TextLineComponent[] makeComponentsOnRange(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = this.trailingCdWhitespaceStart(n, n2);
        int n7 = this.fComponentStart;
        for (n5 = 0; n5 < this.fComponents.length && (n4 = n7 + this.fComponents[n5].getNumCharacters()) <= n; ++n5) {
            n7 = n4;
        }
        boolean bl = false;
        int n8 = n7;
        int n9 = n5;
        int n10 = 1;
        while (n10 != 0) {
            n3 = n8 + this.fComponents[n9].getNumCharacters();
            if (n6 > Math.max(n8, n) && n6 < Math.min(n3, n2)) {
                bl = true;
            }
            if (n3 >= n2) {
                n10 = 0;
            } else {
                n8 = n3;
            }
            ++n9;
        }
        n4 = n9 - n5;
        if (bl) {
            ++n4;
        }
        TextLineComponent[] textLineComponentArray = new TextLineComponent[n4];
        n8 = 0;
        n9 = n;
        n10 = n6;
        if (n10 == n) {
            n3 = this.fIsDirectionLTR ? 0 : 1;
            n10 = n2;
        } else {
            n3 = 2;
        }
        while (n9 < n2) {
            int n11 = this.fComponents[n5].getNumCharacters();
            int n12 = n7 + n11;
            int n13 = Math.max(n9, n7);
            int n14 = Math.min(n10, n12);
            textLineComponentArray[n8++] = this.fComponents[n5].getSubset(n13 - n7, n14 - n7, n3);
            if ((n9 += n14 - n13) == n10) {
                n10 = n2;
                int n15 = n3 = this.fIsDirectionLTR ? 0 : 1;
            }
            if (n9 != n12) continue;
            ++n5;
            n7 = n12;
        }
        return textLineComponentArray;
    }

    private TextLine makeTextLineOnRange(int n, int n2) {
        TextLineComponent[] textLineComponentArray;
        int[] nArray = null;
        byte[] byArray = null;
        if (this.fBidi != null) {
            textLineComponentArray = this.fBidi.createLineBidi(n, n2);
            byArray = BidiUtils.getLevels((Bidi)textLineComponentArray);
            int[] nArray2 = BidiUtils.createVisualToLogicalMap(byArray);
            nArray = BidiUtils.createInverseMap(nArray2);
        }
        textLineComponentArray = this.makeComponentsOnRange(n, n2);
        return new TextLine(this.fFrc, textLineComponentArray, this.fBaselineOffsets, this.fChars, n, n2, nArray, byArray, this.fIsDirectionLTR);
    }

    private void ensureComponents(int n, int n2) {
        if (n < this.fComponentStart || n2 > this.fComponentLimit) {
            this.generateComponents(n, n2);
        }
    }

    private void makeLayoutWindow(int n) {
        int n2 = n;
        int n3 = this.fChars.length;
        if (this.layoutCount > 0 && !this.haveLayoutWindow) {
            float f = Math.max(this.layoutCharCount / this.layoutCount, 1);
            n3 = Math.min(n + (int)(f * EST_LINES), this.fChars.length);
        }
        if (n > 0 || n3 < this.fChars.length) {
            if (this.charIter == null) {
                this.charIter = new CharArrayIterator(this.fChars);
            } else {
                this.charIter.reset(this.fChars);
            }
            if (this.fLineBreak == null) {
                this.fLineBreak = BreakIterator.getLineInstance();
            }
            this.fLineBreak.setText(this.charIter);
            if (n > 0 && !this.fLineBreak.isBoundary(n)) {
                n2 = this.fLineBreak.preceding(n);
            }
            if (n3 < this.fChars.length && !this.fLineBreak.isBoundary(n3)) {
                n3 = this.fLineBreak.following(n3);
            }
        }
        this.ensureComponents(n2, n3);
        this.haveLayoutWindow = true;
    }

    public int getLineBreakIndex(int n, float f) {
        int n2 = n - this.fStart;
        if (!this.haveLayoutWindow || n2 < this.fComponentStart || n2 >= this.fComponentLimit) {
            this.makeLayoutWindow(n2);
        }
        return this.calcLineBreak(n2, f) + this.fStart;
    }

    public float getAdvanceBetween(int n, int n2) {
        int n3 = n - this.fStart;
        int n4 = n2 - this.fStart;
        this.ensureComponents(n3, n4);
        TextLine textLine = this.makeTextLineOnRange(n3, n4);
        return textLine.getMetrics().advance;
    }

    public TextLayout getLayout(int n, int n2) {
        int n3 = n - this.fStart;
        int n4 = n2 - this.fStart;
        this.ensureComponents(n3, n4);
        TextLine textLine = this.makeTextLineOnRange(n3, n4);
        if (n4 < this.fChars.length) {
            this.layoutCharCount += n2 - n;
            ++this.layoutCount;
        }
        return new TextLayout(textLine, this.fBaseline, this.fBaselineOffsets, this.fJustifyRatio);
    }

    private void printStats() {
        System.out.println("formattedChars: " + this.formattedChars);
        this.collectStats = false;
    }

    public void insertChar(AttributedCharacterIterator attributedCharacterIterator, int n) {
        char c;
        if (this.collectStats) {
            this.printStats();
        }
        if (wantStats) {
            this.collectStats = true;
        }
        this.fStart = attributedCharacterIterator.getBeginIndex();
        int n2 = attributedCharacterIterator.getEndIndex();
        if (n2 - this.fStart != this.fChars.length + 1) {
            this.initAll(attributedCharacterIterator);
        }
        char[] cArray = new char[n2 - this.fStart];
        int n3 = n - this.fStart;
        System.arraycopy(this.fChars, 0, cArray, 0, n3);
        cArray[n3] = c = attributedCharacterIterator.setIndex(n);
        System.arraycopy(this.fChars, n3, cArray, n3 + 1, n2 - n - 1);
        this.fChars = cArray;
        if (this.fBidi != null || Bidi.requiresBidi(cArray, n3, n3 + 1) || attributedCharacterIterator.getAttribute(TextAttribute.BIDI_EMBEDDING) != null) {
            this.fBidi = new Bidi(attributedCharacterIterator);
            if (this.fBidi.isLeftToRight()) {
                this.fBidi = null;
            }
        }
        this.fParagraph = StyledParagraph.insertChar(attributedCharacterIterator, this.fChars, n, this.fParagraph);
        this.invalidateComponents();
    }

    public void deleteChar(AttributedCharacterIterator attributedCharacterIterator, int n) {
        this.fStart = attributedCharacterIterator.getBeginIndex();
        int n2 = attributedCharacterIterator.getEndIndex();
        if (n2 - this.fStart != this.fChars.length - 1) {
            this.initAll(attributedCharacterIterator);
        }
        char[] cArray = new char[n2 - this.fStart];
        int n3 = n - this.fStart;
        System.arraycopy(this.fChars, 0, cArray, 0, n - this.fStart);
        System.arraycopy(this.fChars, n3 + 1, cArray, n3, n2 - n);
        this.fChars = cArray;
        if (this.fBidi != null) {
            this.fBidi = new Bidi(attributedCharacterIterator);
            if (this.fBidi.isLeftToRight()) {
                this.fBidi = null;
            }
        }
        this.fParagraph = StyledParagraph.deleteChar(attributedCharacterIterator, this.fChars, n, this.fParagraph);
        this.invalidateComponents();
    }

    char[] getChars() {
        return this.fChars;
    }
}

