/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.concurrent.atomic.Striped64;
import java.util.function.DoubleBinaryOperator;

public class DoubleAccumulator
extends Striped64
implements Serializable {
    private static final long serialVersionUID = 7249069246863182397L;
    private final DoubleBinaryOperator function;
    private final long identity;

    public DoubleAccumulator(DoubleBinaryOperator doubleBinaryOperator, double d) {
        this.function = doubleBinaryOperator;
        this.base = this.identity = Double.doubleToRawLongBits(d);
    }

    public void accumulate(double d) {
        long l;
        long l2;
        Striped64.Cell[] cellArray = this.cells;
        if (this.cells != null || (l2 = Double.doubleToRawLongBits(this.function.applyAsDouble(Double.longBitsToDouble(l = this.base), d))) != l && !this.casBase(l, l2)) {
            long l3;
            Striped64.Cell cell;
            int n;
            boolean bl = true;
            if (cellArray == null || (n = cellArray.length - 1) < 0 || (cell = cellArray[DoubleAccumulator.getProbe() & n]) == null || !(bl = (l2 = Double.doubleToRawLongBits(this.function.applyAsDouble(Double.longBitsToDouble(l3 = cell.value), d))) == l3 || cell.cas(l3, l2))) {
                this.doubleAccumulate(d, this.function, bl);
            }
        }
    }

    public double get() {
        Striped64.Cell[] cellArray = this.cells;
        double d = Double.longBitsToDouble(this.base);
        if (cellArray != null) {
            for (int i = 0; i < cellArray.length; ++i) {
                Striped64.Cell cell = cellArray[i];
                if (cell == null) continue;
                d = this.function.applyAsDouble(d, Double.longBitsToDouble(cell.value));
            }
        }
        return d;
    }

    public void reset() {
        Striped64.Cell[] cellArray = this.cells;
        this.base = this.identity;
        if (cellArray != null) {
            for (int i = 0; i < cellArray.length; ++i) {
                Striped64.Cell cell = cellArray[i];
                if (cell == null) continue;
                cell.value = this.identity;
            }
        }
    }

    public double getThenReset() {
        Striped64.Cell[] cellArray = this.cells;
        double d = Double.longBitsToDouble(this.base);
        this.base = this.identity;
        if (cellArray != null) {
            for (int i = 0; i < cellArray.length; ++i) {
                Striped64.Cell cell = cellArray[i];
                if (cell == null) continue;
                double d2 = Double.longBitsToDouble(cell.value);
                cell.value = this.identity;
                d = this.function.applyAsDouble(d, d2);
            }
        }
        return d;
    }

    public String toString() {
        return Double.toString(this.get());
    }

    @Override
    public double doubleValue() {
        return this.get();
    }

    @Override
    public long longValue() {
        return (long)this.get();
    }

    @Override
    public int intValue() {
        return (int)this.get();
    }

    @Override
    public float floatValue() {
        return (float)this.get();
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 7249069246863182397L;
        private final double value;
        private final DoubleBinaryOperator function;
        private final long identity;

        SerializationProxy(DoubleAccumulator doubleAccumulator) {
            this.function = doubleAccumulator.function;
            this.identity = doubleAccumulator.identity;
            this.value = doubleAccumulator.get();
        }

        private Object readResolve() {
            double d = Double.longBitsToDouble(this.identity);
            DoubleAccumulator doubleAccumulator = new DoubleAccumulator(this.function, d);
            doubleAccumulator.base = Double.doubleToRawLongBits(this.value);
            return doubleAccumulator;
        }
    }
}

