/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.spnego;

import com.sun.security.jgss.ExtendedGSSContext;
import com.sun.security.jgss.InquireType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.Provider;
import org.ietf.jgss.ChannelBinding;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;
import sun.security.action.GetBooleanAction;
import sun.security.jgss.GSSCredentialImpl;
import sun.security.jgss.GSSNameImpl;
import sun.security.jgss.GSSUtil;
import sun.security.jgss.spi.GSSContextSpi;
import sun.security.jgss.spi.GSSCredentialSpi;
import sun.security.jgss.spi.GSSNameSpi;
import sun.security.jgss.spnego.NegTokenInit;
import sun.security.jgss.spnego.NegTokenTarg;
import sun.security.jgss.spnego.SpNegoCredElement;
import sun.security.jgss.spnego.SpNegoMechFactory;
import sun.security.jgss.spnego.SpNegoToken;
import sun.security.util.BitArray;
import sun.security.util.DerOutputStream;

public class SpNegoContext
implements GSSContextSpi {
    private static final int STATE_NEW = 1;
    private static final int STATE_IN_PROCESS = 2;
    private static final int STATE_DONE = 3;
    private static final int STATE_DELETED = 4;
    private int state = 1;
    private boolean credDelegState = false;
    private boolean mutualAuthState = true;
    private boolean replayDetState = true;
    private boolean sequenceDetState = true;
    private boolean confState = true;
    private boolean integState = true;
    private boolean delegPolicyState = false;
    private GSSNameSpi peerName = null;
    private GSSNameSpi myName = null;
    private SpNegoCredElement myCred = null;
    private GSSContext mechContext = null;
    private byte[] DER_mechTypes = null;
    private int lifetime;
    private ChannelBinding channelBinding;
    private boolean initiator;
    private Oid internal_mech = null;
    private final SpNegoMechFactory factory;
    static final boolean DEBUG = AccessController.doPrivileged(new GetBooleanAction("sun.security.spnego.debug"));

    public SpNegoContext(SpNegoMechFactory spNegoMechFactory, GSSNameSpi gSSNameSpi, GSSCredentialSpi gSSCredentialSpi, int n) throws GSSException {
        if (gSSNameSpi == null) {
            throw new IllegalArgumentException("Cannot have null peer name");
        }
        if (gSSCredentialSpi != null && !(gSSCredentialSpi instanceof SpNegoCredElement)) {
            throw new IllegalArgumentException("Wrong cred element type");
        }
        this.peerName = gSSNameSpi;
        this.myCred = (SpNegoCredElement)gSSCredentialSpi;
        this.lifetime = n;
        this.initiator = true;
        this.factory = spNegoMechFactory;
    }

    public SpNegoContext(SpNegoMechFactory spNegoMechFactory, GSSCredentialSpi gSSCredentialSpi) throws GSSException {
        if (gSSCredentialSpi != null && !(gSSCredentialSpi instanceof SpNegoCredElement)) {
            throw new IllegalArgumentException("Wrong cred element type");
        }
        this.myCred = (SpNegoCredElement)gSSCredentialSpi;
        this.initiator = false;
        this.factory = spNegoMechFactory;
    }

    public SpNegoContext(SpNegoMechFactory spNegoMechFactory, byte[] byArray) throws GSSException {
        throw new GSSException(16, -1, "GSS Import Context not available");
    }

    @Override
    public final void requestConf(boolean bl) throws GSSException {
        if (this.state == 1 && this.isInitiator()) {
            this.confState = bl;
        }
    }

    @Override
    public final boolean getConfState() {
        return this.confState;
    }

    @Override
    public final void requestInteg(boolean bl) throws GSSException {
        if (this.state == 1 && this.isInitiator()) {
            this.integState = bl;
        }
    }

    @Override
    public final void requestDelegPolicy(boolean bl) throws GSSException {
        if (this.state == 1 && this.isInitiator()) {
            this.delegPolicyState = bl;
        }
    }

    @Override
    public final boolean getIntegState() {
        return this.integState;
    }

    @Override
    public final boolean getDelegPolicyState() {
        if (this.isInitiator() && this.mechContext != null && this.mechContext instanceof ExtendedGSSContext && (this.state == 2 || this.state == 3)) {
            return ((ExtendedGSSContext)this.mechContext).getDelegPolicyState();
        }
        return this.delegPolicyState;
    }

    @Override
    public final void requestCredDeleg(boolean bl) throws GSSException {
        if (this.state == 1 && this.isInitiator()) {
            this.credDelegState = bl;
        }
    }

    @Override
    public final boolean getCredDelegState() {
        if (this.isInitiator() && this.mechContext != null && (this.state == 2 || this.state == 3)) {
            return this.mechContext.getCredDelegState();
        }
        return this.credDelegState;
    }

    @Override
    public final void requestMutualAuth(boolean bl) throws GSSException {
        if (this.state == 1 && this.isInitiator()) {
            this.mutualAuthState = bl;
        }
    }

    @Override
    public final boolean getMutualAuthState() {
        return this.mutualAuthState;
    }

    @Override
    public final Oid getMech() {
        if (this.isEstablished()) {
            return this.getNegotiatedMech();
        }
        return SpNegoMechFactory.GSS_SPNEGO_MECH_OID;
    }

    public final Oid getNegotiatedMech() {
        return this.internal_mech;
    }

    @Override
    public final Provider getProvider() {
        return SpNegoMechFactory.PROVIDER;
    }

    @Override
    public final void dispose() throws GSSException {
        this.state = 4;
        if (this.mechContext != null) {
            this.mechContext.dispose();
            this.mechContext = null;
        }
    }

    @Override
    public final boolean isInitiator() {
        return this.initiator;
    }

    @Override
    public final boolean isProtReady() {
        return this.state == 3;
    }

    @Override
    public final byte[] initSecContext(InputStream inputStream, int n) throws GSSException {
        byte[] byArray = null;
        NegTokenInit negTokenInit = null;
        byte[] byArray2 = null;
        int n2 = 11;
        if (DEBUG) {
            System.out.println("Entered SpNego.initSecContext with state=" + SpNegoContext.printState(this.state));
        }
        if (!this.isInitiator()) {
            throw new GSSException(11, -1, "initSecContext on an acceptor GSSContext");
        }
        try {
            if (this.state == 1) {
                this.state = 2;
                n2 = 13;
                Oid[] oidArray = this.getAvailableMechs();
                this.DER_mechTypes = this.getEncodedMechs(oidArray);
                this.internal_mech = oidArray[0];
                byArray2 = this.GSS_initSecContext(null);
                n2 = 10;
                negTokenInit = new NegTokenInit(this.DER_mechTypes, this.getContextFlags(), byArray2, null);
                if (DEBUG) {
                    System.out.println("SpNegoContext.initSecContext: sending token of type = " + SpNegoToken.getTokenName(negTokenInit.getType()));
                }
                byArray = negTokenInit.getEncoded();
            } else if (this.state == 2) {
                n2 = 11;
                if (inputStream == null) {
                    throw new GSSException(n2, -1, "No token received from peer!");
                }
                n2 = 10;
                byte[] byArray3 = new byte[inputStream.available()];
                SpNegoToken.readFully(inputStream, byArray3);
                if (DEBUG) {
                    System.out.println("SpNegoContext.initSecContext: process received token = " + SpNegoToken.getHexBytes(byArray3));
                }
                NegTokenTarg negTokenTarg = new NegTokenTarg(byArray3);
                if (DEBUG) {
                    System.out.println("SpNegoContext.initSecContext: received token of type = " + SpNegoToken.getTokenName(negTokenTarg.getType()));
                }
                this.internal_mech = negTokenTarg.getSupportedMech();
                if (this.internal_mech == null) {
                    throw new GSSException(n2, -1, "supported mechanism from server is null");
                }
                SpNegoToken.NegoResult negoResult = null;
                int n3 = negTokenTarg.getNegotiatedResult();
                switch (n3) {
                    case 0: {
                        negoResult = SpNegoToken.NegoResult.ACCEPT_COMPLETE;
                        this.state = 3;
                        break;
                    }
                    case 1: {
                        negoResult = SpNegoToken.NegoResult.ACCEPT_INCOMPLETE;
                        this.state = 2;
                        break;
                    }
                    case 2: {
                        negoResult = SpNegoToken.NegoResult.REJECT;
                        this.state = 4;
                        break;
                    }
                    default: {
                        this.state = 3;
                    }
                }
                n2 = 2;
                if (negoResult == SpNegoToken.NegoResult.REJECT) {
                    throw new GSSException(n2, -1, this.internal_mech.toString());
                }
                n2 = 10;
                if (negoResult == SpNegoToken.NegoResult.ACCEPT_COMPLETE || negoResult == SpNegoToken.NegoResult.ACCEPT_INCOMPLETE) {
                    byte[] byArray4;
                    byte[] byArray5 = negTokenTarg.getResponseToken();
                    if (byArray5 == null) {
                        if (!this.isMechContextEstablished()) {
                            throw new GSSException(n2, -1, "mechanism token from server is null");
                        }
                    } else {
                        byArray2 = this.GSS_initSecContext(byArray5);
                    }
                    if (!GSSUtil.useMSInterop() && !this.verifyMechListMIC(this.DER_mechTypes, byArray4 = negTokenTarg.getMechListMIC())) {
                        throw new GSSException(n2, -1, "verification of MIC on MechList Failed!");
                    }
                    if (this.isMechContextEstablished()) {
                        this.state = 3;
                        byArray = byArray2;
                        if (DEBUG) {
                            System.out.println("SPNEGO Negotiated Mechanism = " + this.internal_mech + " " + GSSUtil.getMechStr(this.internal_mech));
                        }
                    } else {
                        negTokenInit = new NegTokenInit(null, null, byArray2, null);
                        if (DEBUG) {
                            System.out.println("SpNegoContext.initSecContext: continue sending token of type = " + SpNegoToken.getTokenName(negTokenInit.getType()));
                        }
                        byArray = negTokenInit.getEncoded();
                    }
                }
            } else if (DEBUG) {
                System.out.println(this.state);
            }
            if (DEBUG && byArray != null) {
                System.out.println("SNegoContext.initSecContext: sending token = " + SpNegoToken.getHexBytes(byArray));
            }
        }
        catch (GSSException gSSException) {
            GSSException gSSException2 = new GSSException(n2, -1, gSSException.getMessage());
            gSSException2.initCause(gSSException);
            throw gSSException2;
        }
        catch (IOException iOException) {
            GSSException gSSException = new GSSException(11, -1, iOException.getMessage());
            gSSException.initCause(iOException);
            throw gSSException;
        }
        return byArray;
    }

    @Override
    public final byte[] acceptSecContext(InputStream inputStream, int n) throws GSSException {
        byte[] byArray = null;
        boolean bl = true;
        if (DEBUG) {
            System.out.println("Entered SpNegoContext.acceptSecContext with state=" + SpNegoContext.printState(this.state));
        }
        if (this.isInitiator()) {
            throw new GSSException(11, -1, "acceptSecContext on an initiator GSSContext");
        }
        try {
            if (this.state == 1) {
                SpNegoToken.NegoResult negoResult;
                byte[] byArray2;
                Object object;
                Oid[] oidArray;
                Oid oid;
                this.state = 2;
                byte[] byArray3 = new byte[inputStream.available()];
                SpNegoToken.readFully(inputStream, byArray3);
                if (DEBUG) {
                    System.out.println("SpNegoContext.acceptSecContext: receiving token = " + SpNegoToken.getHexBytes(byArray3));
                }
                NegTokenInit negTokenInit = new NegTokenInit(byArray3);
                if (DEBUG) {
                    System.out.println("SpNegoContext.acceptSecContext: received token of type = " + SpNegoToken.getTokenName(negTokenInit.getType()));
                }
                Oid[] oidArray2 = negTokenInit.getMechTypeList();
                this.DER_mechTypes = negTokenInit.getMechTypes();
                if (this.DER_mechTypes == null) {
                    bl = false;
                }
                if ((oid = SpNegoContext.negotiate_mech_type(oidArray = this.getAvailableMechs(), oidArray2)) == null) {
                    bl = false;
                }
                this.internal_mech = oid;
                if (oidArray2[0].equals(oid) || GSSUtil.isKerberosMech(oidArray2[0]) && GSSUtil.isKerberosMech(oid)) {
                    if (DEBUG && !oid.equals(oidArray2[0])) {
                        System.out.println("SpNegoContext.acceptSecContext: negotiated mech adjusted to " + oidArray2[0]);
                    }
                    if ((object = negTokenInit.getMechToken()) == null) {
                        throw new GSSException(11, -1, "mechToken is missing");
                    }
                    byArray2 = this.GSS_acceptSecContext((byte[])object);
                    oid = oidArray2[0];
                } else {
                    byArray2 = null;
                }
                if (!GSSUtil.useMSInterop() && bl) {
                    bl = this.verifyMechListMIC(this.DER_mechTypes, negTokenInit.getMechListMIC());
                }
                if (bl) {
                    if (this.isMechContextEstablished()) {
                        negoResult = SpNegoToken.NegoResult.ACCEPT_COMPLETE;
                        this.state = 3;
                        this.setContextFlags();
                        if (DEBUG) {
                            System.out.println("SPNEGO Negotiated Mechanism = " + this.internal_mech + " " + GSSUtil.getMechStr(this.internal_mech));
                        }
                    } else {
                        negoResult = SpNegoToken.NegoResult.ACCEPT_INCOMPLETE;
                        this.state = 2;
                    }
                } else {
                    negoResult = SpNegoToken.NegoResult.REJECT;
                    this.state = 3;
                }
                if (DEBUG) {
                    System.out.println("SpNegoContext.acceptSecContext: mechanism wanted = " + oid);
                    System.out.println("SpNegoContext.acceptSecContext: negotiated result = " + (Object)((Object)negoResult));
                }
                object = new NegTokenTarg(negoResult.ordinal(), oid, byArray2, null);
                if (DEBUG) {
                    System.out.println("SpNegoContext.acceptSecContext: sending token of type = " + SpNegoToken.getTokenName(((SpNegoToken)object).getType()));
                }
                byArray = ((SpNegoToken)object).getEncoded();
            } else if (this.state == 2) {
                SpNegoToken.NegoResult negoResult;
                byte[] byArray4;
                byte[] byArray5;
                byte[] byArray6 = new byte[inputStream.available()];
                SpNegoToken.readFully(inputStream, byArray6);
                if (DEBUG) {
                    System.out.println("SpNegoContext.acceptSecContext: receiving token = " + SpNegoToken.getHexBytes(byArray6));
                }
                NegTokenTarg negTokenTarg = new NegTokenTarg(byArray6);
                if (DEBUG) {
                    System.out.println("SpNegoContext.acceptSecContext: received token of type = " + SpNegoToken.getTokenName(negTokenTarg.getType()));
                }
                if ((byArray5 = this.GSS_acceptSecContext(byArray4 = negTokenTarg.getResponseToken())) == null) {
                    bl = false;
                }
                if (bl) {
                    if (this.isMechContextEstablished()) {
                        negoResult = SpNegoToken.NegoResult.ACCEPT_COMPLETE;
                        this.state = 3;
                    } else {
                        negoResult = SpNegoToken.NegoResult.ACCEPT_INCOMPLETE;
                        this.state = 2;
                    }
                } else {
                    negoResult = SpNegoToken.NegoResult.REJECT;
                    this.state = 3;
                }
                NegTokenTarg negTokenTarg2 = new NegTokenTarg(negoResult.ordinal(), null, byArray5, null);
                if (DEBUG) {
                    System.out.println("SpNegoContext.acceptSecContext: sending token of type = " + SpNegoToken.getTokenName(negTokenTarg2.getType()));
                }
                byArray = negTokenTarg2.getEncoded();
            } else if (DEBUG) {
                System.out.println("AcceptSecContext: state = " + this.state);
            }
            if (DEBUG) {
                System.out.println("SpNegoContext.acceptSecContext: sending token = " + SpNegoToken.getHexBytes(byArray));
            }
        }
        catch (IOException iOException) {
            GSSException gSSException = new GSSException(11, -1, iOException.getMessage());
            gSSException.initCause(iOException);
            throw gSSException;
        }
        if (this.state == 3) {
            this.setContextFlags();
        }
        return byArray;
    }

    private Oid[] getAvailableMechs() {
        if (this.myCred != null) {
            Oid[] oidArray = new Oid[]{this.myCred.getInternalMech()};
            return oidArray;
        }
        return this.factory.availableMechs;
    }

    private byte[] getEncodedMechs(Oid[] oidArray) throws IOException, GSSException {
        byte[] byArray;
        DerOutputStream derOutputStream = new DerOutputStream();
        for (int i = 0; i < oidArray.length; ++i) {
            byArray = oidArray[i].getDER();
            derOutputStream.write(byArray);
        }
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        byArray = derOutputStream2.toByteArray();
        return byArray;
    }

    private BitArray getContextFlags() {
        BitArray bitArray = new BitArray(7);
        if (this.getCredDelegState()) {
            bitArray.set(0, true);
        }
        if (this.getMutualAuthState()) {
            bitArray.set(1, true);
        }
        if (this.getReplayDetState()) {
            bitArray.set(2, true);
        }
        if (this.getSequenceDetState()) {
            bitArray.set(3, true);
        }
        if (this.getConfState()) {
            bitArray.set(5, true);
        }
        if (this.getIntegState()) {
            bitArray.set(6, true);
        }
        return bitArray;
    }

    private void setContextFlags() {
        if (this.mechContext != null) {
            if (this.mechContext.getCredDelegState()) {
                this.credDelegState = true;
            }
            if (!this.mechContext.getMutualAuthState()) {
                this.mutualAuthState = false;
            }
            if (!this.mechContext.getReplayDetState()) {
                this.replayDetState = false;
            }
            if (!this.mechContext.getSequenceDetState()) {
                this.sequenceDetState = false;
            }
            if (!this.mechContext.getIntegState()) {
                this.integState = false;
            }
            if (!this.mechContext.getConfState()) {
                this.confState = false;
            }
        }
    }

    private boolean verifyMechListMIC(byte[] byArray, byte[] byArray2) throws GSSException {
        boolean bl;
        block6: {
            if (byArray2 == null) {
                if (DEBUG) {
                    System.out.println("SpNegoContext: no MIC token validation");
                }
                return true;
            }
            if (!this.mechContext.getIntegState()) {
                if (DEBUG) {
                    System.out.println("SpNegoContext: no MIC token validation - mechanism does not support integrity");
                }
                return true;
            }
            bl = false;
            try {
                MessageProp messageProp = new MessageProp(0, true);
                this.verifyMIC(byArray2, 0, byArray2.length, byArray, 0, byArray.length, messageProp);
                bl = true;
            }
            catch (GSSException gSSException) {
                bl = false;
                if (!DEBUG) break block6;
                System.out.println("SpNegoContext: MIC validation failed! " + gSSException.getMessage());
            }
        }
        return bl;
    }

    private byte[] GSS_initSecContext(byte[] byArray) throws GSSException {
        Object object;
        byte[] byArray2 = null;
        if (this.mechContext == null) {
            object = this.factory.manager.createName(this.peerName.toString(), this.peerName.getStringNameType(), this.internal_mech);
            GSSCredentialImpl gSSCredentialImpl = null;
            if (this.myCred != null) {
                gSSCredentialImpl = new GSSCredentialImpl(this.factory.manager, this.myCred.getInternalCred());
            }
            this.mechContext = this.factory.manager.createContext((GSSName)object, this.internal_mech, gSSCredentialImpl, 0);
            this.mechContext.requestConf(this.confState);
            this.mechContext.requestInteg(this.integState);
            this.mechContext.requestCredDeleg(this.credDelegState);
            this.mechContext.requestMutualAuth(this.mutualAuthState);
            this.mechContext.requestReplayDet(this.replayDetState);
            this.mechContext.requestSequenceDet(this.sequenceDetState);
            if (this.mechContext instanceof ExtendedGSSContext) {
                ((ExtendedGSSContext)this.mechContext).requestDelegPolicy(this.delegPolicyState);
            }
        }
        byArray2 = byArray != null ? byArray : new byte[]{};
        object = this.mechContext.initSecContext(byArray2, 0, byArray2.length);
        return object;
    }

    private byte[] GSS_acceptSecContext(byte[] byArray) throws GSSException {
        Object object;
        if (this.mechContext == null) {
            object = null;
            if (this.myCred != null) {
                object = new GSSCredentialImpl(this.factory.manager, this.myCred.getInternalCred());
            }
            this.mechContext = this.factory.manager.createContext((GSSCredential)object);
        }
        object = this.mechContext.acceptSecContext(byArray, 0, byArray.length);
        return object;
    }

    private static Oid negotiate_mech_type(Oid[] oidArray, Oid[] oidArray2) {
        for (int i = 0; i < oidArray.length; ++i) {
            for (int j = 0; j < oidArray2.length; ++j) {
                if (!oidArray2[j].equals(oidArray[i])) continue;
                if (DEBUG) {
                    System.out.println("SpNegoContext: negotiated mechanism = " + oidArray2[j]);
                }
                return oidArray2[j];
            }
        }
        return null;
    }

    @Override
    public final boolean isEstablished() {
        return this.state == 3;
    }

    public final boolean isMechContextEstablished() {
        if (this.mechContext != null) {
            return this.mechContext.isEstablished();
        }
        if (DEBUG) {
            System.out.println("The underlying mechanism context has not been initialized");
        }
        return false;
    }

    @Override
    public final byte[] export() throws GSSException {
        throw new GSSException(16, -1, "GSS Export Context not available");
    }

    @Override
    public final void setChannelBinding(ChannelBinding channelBinding) throws GSSException {
        this.channelBinding = channelBinding;
    }

    final ChannelBinding getChannelBinding() {
        return this.channelBinding;
    }

    @Override
    public final void requestAnonymity(boolean bl) throws GSSException {
    }

    @Override
    public final boolean getAnonymityState() {
        return false;
    }

    @Override
    public void requestLifetime(int n) throws GSSException {
        if (this.state == 1 && this.isInitiator()) {
            this.lifetime = n;
        }
    }

    @Override
    public final int getLifetime() {
        if (this.mechContext != null) {
            return this.mechContext.getLifetime();
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public final boolean isTransferable() throws GSSException {
        return false;
    }

    @Override
    public final void requestSequenceDet(boolean bl) throws GSSException {
        if (this.state == 1 && this.isInitiator()) {
            this.sequenceDetState = bl;
        }
    }

    @Override
    public final boolean getSequenceDetState() {
        return this.sequenceDetState || this.replayDetState;
    }

    @Override
    public final void requestReplayDet(boolean bl) throws GSSException {
        if (this.state == 1 && this.isInitiator()) {
            this.replayDetState = bl;
        }
    }

    @Override
    public final boolean getReplayDetState() {
        return this.replayDetState || this.sequenceDetState;
    }

    @Override
    public final GSSNameSpi getTargName() throws GSSException {
        if (this.mechContext != null) {
            GSSNameImpl gSSNameImpl = (GSSNameImpl)this.mechContext.getTargName();
            this.peerName = gSSNameImpl.getElement(this.internal_mech);
            return this.peerName;
        }
        if (DEBUG) {
            System.out.println("The underlying mechanism context has not been initialized");
        }
        return null;
    }

    @Override
    public final GSSNameSpi getSrcName() throws GSSException {
        if (this.mechContext != null) {
            GSSNameImpl gSSNameImpl = (GSSNameImpl)this.mechContext.getSrcName();
            this.myName = gSSNameImpl.getElement(this.internal_mech);
            return this.myName;
        }
        if (DEBUG) {
            System.out.println("The underlying mechanism context has not been initialized");
        }
        return null;
    }

    @Override
    public final GSSCredentialSpi getDelegCred() throws GSSException {
        if (this.state != 2 && this.state != 3) {
            throw new GSSException(12);
        }
        if (this.mechContext != null) {
            GSSCredentialImpl gSSCredentialImpl = (GSSCredentialImpl)this.mechContext.getDelegCred();
            if (gSSCredentialImpl == null) {
                return null;
            }
            boolean bl = false;
            if (gSSCredentialImpl.getUsage() == 1) {
                bl = true;
            }
            GSSCredentialSpi gSSCredentialSpi = gSSCredentialImpl.getElement(this.internal_mech, bl);
            SpNegoCredElement spNegoCredElement = new SpNegoCredElement(gSSCredentialSpi);
            return spNegoCredElement.getInternalCred();
        }
        throw new GSSException(12, -1, "getDelegCred called in invalid state!");
    }

    @Override
    public final int getWrapSizeLimit(int n, boolean bl, int n2) throws GSSException {
        if (this.mechContext != null) {
            return this.mechContext.getWrapSizeLimit(n, bl, n2);
        }
        throw new GSSException(12, -1, "getWrapSizeLimit called in invalid state!");
    }

    @Override
    public final byte[] wrap(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        if (this.mechContext != null) {
            return this.mechContext.wrap(byArray, n, n2, messageProp);
        }
        throw new GSSException(12, -1, "Wrap called in invalid state!");
    }

    @Override
    public final void wrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        if (this.mechContext == null) {
            throw new GSSException(12, -1, "Wrap called in invalid state!");
        }
        this.mechContext.wrap(inputStream, outputStream, messageProp);
    }

    @Override
    public final byte[] unwrap(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        if (this.mechContext != null) {
            return this.mechContext.unwrap(byArray, n, n2, messageProp);
        }
        throw new GSSException(12, -1, "UnWrap called in invalid state!");
    }

    @Override
    public final void unwrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        if (this.mechContext == null) {
            throw new GSSException(12, -1, "UnWrap called in invalid state!");
        }
        this.mechContext.unwrap(inputStream, outputStream, messageProp);
    }

    @Override
    public final byte[] getMIC(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        if (this.mechContext != null) {
            return this.mechContext.getMIC(byArray, n, n2, messageProp);
        }
        throw new GSSException(12, -1, "getMIC called in invalid state!");
    }

    @Override
    public final void getMIC(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        if (this.mechContext == null) {
            throw new GSSException(12, -1, "getMIC called in invalid state!");
        }
        this.mechContext.getMIC(inputStream, outputStream, messageProp);
    }

    @Override
    public final void verifyMIC(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, MessageProp messageProp) throws GSSException {
        if (this.mechContext == null) {
            throw new GSSException(12, -1, "verifyMIC called in invalid state!");
        }
        this.mechContext.verifyMIC(byArray, n, n2, byArray2, n3, n4, messageProp);
    }

    @Override
    public final void verifyMIC(InputStream inputStream, InputStream inputStream2, MessageProp messageProp) throws GSSException {
        if (this.mechContext == null) {
            throw new GSSException(12, -1, "verifyMIC called in invalid state!");
        }
        this.mechContext.verifyMIC(inputStream, inputStream2, messageProp);
    }

    private static String printState(int n) {
        switch (n) {
            case 1: {
                return "STATE_NEW";
            }
            case 2: {
                return "STATE_IN_PROCESS";
            }
            case 3: {
                return "STATE_DONE";
            }
            case 4: {
                return "STATE_DELETED";
            }
        }
        return "Unknown state " + n;
    }

    @Override
    public Object inquireSecContext(InquireType inquireType) throws GSSException {
        if (this.mechContext == null) {
            throw new GSSException(12, -1, "Underlying mech not established.");
        }
        if (this.mechContext instanceof ExtendedGSSContext) {
            return ((ExtendedGSSContext)this.mechContext).inquireSecContext(inquireType);
        }
        throw new GSSException(2, -1, "inquireSecContext not supported by underlying mech.");
    }
}

