/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Enumeration;
import java.util.Map;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.jboss.logging.Logger;

public final class JarUnsigner {
    private static final Logger log = Logger.getLogger(JarUnsigner.class);

    private JarUnsigner() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unsignJar(Path jarPath, Path targetPath) throws IOException {
        try (JarFile in = new JarFile(jarPath.toFile(), false);){
            boolean signed;
            Manifest manifest = in.getManifest();
            if (manifest != null) {
                Map<String, Attributes> entries = manifest.getEntries();
                signed = !entries.isEmpty();
                entries.clear();
            } else {
                signed = false;
                manifest = new Manifest();
            }
            if (!signed) {
                in.close();
                log.debugf("JAR %s is not signed, skipping unsigning", (Object)jarPath);
                Files.copy(jarPath, targetPath, StandardCopyOption.REPLACE_EXISTING);
            } else {
                log.debugf("JAR %s is signed, removing signature", (Object)jarPath);
                byte[] buffer = new byte[10000];
                try (JarOutputStream out = new JarOutputStream(Files.newOutputStream(targetPath, new OpenOption[0]));){
                    JarEntry manifestEntry = new JarEntry("META-INF/MANIFEST.MF");
                    manifestEntry.setTime(0L);
                    out.putNextEntry(manifestEntry);
                    manifest.write(out);
                    out.closeEntry();
                    Enumeration<JarEntry> entries = in.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        String entryName = entry.getName();
                        if (!(entryName.equals("META-INF/MANIFEST.MF") || entryName.equals("META-INF/INDEX.LIST") || JarUnsigner.isSignatureFile(entryName))) {
                            entry.setCompressedSize(-1L);
                            out.putNextEntry(entry);
                            try {
                                InputStream inStream = in.getInputStream(entry);
                                try {
                                    int r;
                                    while ((r = inStream.read(buffer)) > 0) {
                                        out.write(buffer, 0, r);
                                    }
                                    continue;
                                }
                                finally {
                                    if (inStream != null) {
                                        inStream.close();
                                    }
                                    continue;
                                }
                            }
                            finally {
                                out.closeEntry();
                                continue;
                            }
                        }
                        log.debugf("Removed %s from %s", (Object)entryName, (Object)jarPath);
                    }
                }
            }
            Files.setLastModifiedTime(targetPath, Files.getLastModifiedTime(jarPath, new LinkOption[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unsignJar(Path jarPath, Path targetPath, Predicate<String> includePredicate) throws IOException {
        byte[] buffer = new byte[10000];
        try (JarFile in = new JarFile(jarPath.toFile(), false);){
            boolean signed;
            Manifest manifest = in.getManifest();
            if (manifest != null) {
                Map<String, Attributes> entries = manifest.getEntries();
                signed = !entries.isEmpty();
                entries.clear();
            } else {
                signed = false;
                manifest = new Manifest();
            }
            if (signed) {
                log.debugf("JAR %s is signed, removing signature", (Object)jarPath);
            }
            try (JarOutputStream out = new JarOutputStream(Files.newOutputStream(targetPath, new OpenOption[0]));){
                JarEntry manifestEntry = new JarEntry("META-INF/MANIFEST.MF");
                manifestEntry.setTime(0L);
                out.putNextEntry(manifestEntry);
                manifest.write(out);
                out.closeEntry();
                Enumeration<JarEntry> entries = in.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String entryName = entry.getName();
                    if (includePredicate.test(entryName) && !entryName.equals("META-INF/MANIFEST.MF") && !entryName.equals("META-INF/INDEX.LIST") && !JarUnsigner.isSignatureFile(entryName)) {
                        entry.setCompressedSize(-1L);
                        out.putNextEntry(entry);
                        try {
                            InputStream inStream = in.getInputStream(entry);
                            try {
                                int r;
                                while ((r = inStream.read(buffer)) > 0) {
                                    out.write(buffer, 0, r);
                                }
                                continue;
                            }
                            finally {
                                if (inStream != null) {
                                    inStream.close();
                                }
                                continue;
                            }
                        }
                        finally {
                            out.closeEntry();
                            continue;
                        }
                    }
                    log.debugf("Removed %s from %s", (Object)entryName, (Object)jarPath);
                }
            }
            Files.setLastModifiedTime(targetPath, Files.getLastModifiedTime(jarPath, new LinkOption[0]));
        }
    }

    private static boolean isSignatureFile(String entry) {
        if ((entry = entry.toUpperCase()).startsWith("META-INF/") && entry.indexOf(47, "META-INF/".length()) == -1) {
            return entry.endsWith(".SF") || entry.endsWith(".DSA") || entry.endsWith(".RSA") || entry.endsWith(".EC");
        }
        return false;
    }
}

