"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = adPlugin;
var _constants = require("../../utils/constants");
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

function adPlugin(Client, config, components) {
  const ca = components.clientAction.factory;
  Client.prototype.ad = components.clientAction.namespaceFactory();
  const ad = Client.prototype.ad.prototype;
  ad.deleteDetector = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/<%=detectorId%>`,
      req: {
        detectorId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'DELETE'
  });
  ad.previewDetector = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/_preview`
    },
    needBody: true,
    method: 'POST'
  });
  ad.createDetector = ca({
    url: {
      fmt: _constants.API.DETECTOR_BASE
    },
    needBody: true,
    method: 'POST'
  });
  ad.validateDetector = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/_validate/<%=validationType%>`,
      req: {
        validationType: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'POST'
  });
  ad.suggestDetector = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/_suggest/<%=suggestType%>`,
      req: {
        suggestType: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'POST'
  });
  ad.searchDetector = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/_search`
    },
    needBody: true,
    method: 'POST'
  });
  ad.searchTasks = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/tasks/_search`
    },
    needBody: true,
    method: 'POST'
  });
  ad.updateDetector = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/<%=detectorId%>?if_seq_no=<%=ifSeqNo%>&if_primary_term=<%=ifPrimaryTerm%>&refresh=wait_for`,
      req: {
        detectorId: {
          type: 'string',
          required: true
        },
        ifSeqNo: {
          type: 'string',
          required: true
        },
        ifPrimaryTerm: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'PUT'
  });
  ad.getDetector = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/<%=detectorId%>?job=true&task=true`,
      req: {
        detectorId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  ad.searchResults = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/results/_search`
    },
    needBody: true,
    method: 'POST'
  });
  ad.searchResultsFromCustomResultIndex = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/results/_search/<%=resultIndex%>?only_query_custom_result_index=<%=onlyQueryCustomResultIndex%>`,
      req: {
        resultIndex: {
          type: 'string',
          required: false
        },
        onlyQueryCustomResultIndex: {
          type: 'string',
          required: false
        }
      }
    },
    needBody: true,
    method: 'POST'
  });
  ad.startDetector = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/<%=detectorId%>/_start`,
      req: {
        detectorId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'POST'
  });
  ad.startHistoricalDetector = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/<%=detectorId%>/_start`,
      req: {
        detectorId: {
          type: 'string',
          required: true
        }
      },
      needBody: true
    },
    method: 'POST'
  });
  ad.stopDetector = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/<%=detectorId%>/_stop`,
      req: {
        detectorId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'POST'
  });
  ad.stopHistoricalDetector = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/<%=detectorId%>/_stop?historical=true`,
      req: {
        detectorId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'POST'
  });
  ad.detectorProfile = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/<%=detectorId%>/_profile/init_progress,state,error`,
      req: {
        detectorId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  ad.matchDetector = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/match?name=<%=detectorName%>`,
      req: {
        detectorName: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'GET'
  });
  ad.detectorCount = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/count`
    },
    method: 'GET'
  });
  ad.topAnomalyResults = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/<%=detectorId%>/results/_topAnomalies?historical=false`,
      req: {
        detectorId: {
          type: 'string',
          required: true
        }
      },
      needBody: true
    },
    method: 'POST'
  });
  ad.topHistoricalAnomalyResults = ca({
    url: {
      fmt: `${_constants.API.DETECTOR_BASE}/<%=detectorId%>/results/_topAnomalies?historical=true`,
      req: {
        detectorId: {
          type: 'string',
          required: true
        }
      },
      needBody: true
    },
    method: 'POST'
  });
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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