/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.executor;

import com.amazon.randomcutforest.ComponentList;
import com.amazon.randomcutforest.executor.IStateCoordinator;
import com.amazon.randomcutforest.executor.UpdateResult;
import com.amazon.randomcutforest.store.IPointStore;
import com.amazon.randomcutforest.util.ArrayUtils;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

public abstract class AbstractForestUpdateExecutor<PointReference, Point> {
    protected final IStateCoordinator<PointReference, Point> updateCoordinator;
    protected final ComponentList<PointReference, Point> components;

    protected AbstractForestUpdateExecutor(IStateCoordinator<PointReference, Point> updateCoordinator, ComponentList<PointReference, Point> components) {
        this.updateCoordinator = updateCoordinator;
        this.components = components;
    }

    public void update(float[] point) {
        long internalSequenceNumber = this.updateCoordinator.getTotalUpdates();
        IPointStore<Point> store = this.updateCoordinator.getStore();
        if (store != null && store.isInternalShinglingEnabled()) {
            internalSequenceNumber -= (long)(store.getShingleSize() - 1);
        }
        this.update(point, internalSequenceNumber);
    }

    public void update(float[] point, long sequenceNumber) {
        float[] pointCopy = ArrayUtils.cleanCopy(point);
        PointReference updateInput = this.updateCoordinator.initUpdate(pointCopy, sequenceNumber);
        List results = updateInput == null ? Collections.emptyList() : this.update(updateInput, sequenceNumber);
        this.updateCoordinator.completeUpdate(results, updateInput);
    }

    protected abstract List<UpdateResult<PointReference>> update(PointReference var1, long var2);

    @Generated
    public IStateCoordinator<PointReference, Point> getUpdateCoordinator() {
        return this.updateCoordinator;
    }

    @Generated
    public ComponentList<PointReference, Point> getComponents() {
        return this.components;
    }
}

