/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.indices.stats.ShardLease;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ShardRetentionLeases
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ShardRetentionLeases> {
    @Nonnull
    private final List<ShardLease> leases;
    private final long primaryTerm;
    private final long version;
    public static final JsonpDeserializer<ShardRetentionLeases> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardRetentionLeases::setupShardRetentionLeasesDeserializer);

    private ShardRetentionLeases(Builder builder) {
        this.leases = ApiTypeHelper.unmodifiableRequired(builder.leases, (Object)this, "leases");
        this.primaryTerm = ApiTypeHelper.requireNonNull(builder.primaryTerm, this, "primaryTerm");
        this.version = ApiTypeHelper.requireNonNull(builder.version, this, "version");
    }

    public static ShardRetentionLeases of(Function<Builder, ObjectBuilder<ShardRetentionLeases>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<ShardLease> leases() {
        return this.leases;
    }

    public final long primaryTerm() {
        return this.primaryTerm;
    }

    public final long version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("leases");
        generator.writeStartArray();
        for (ShardLease item0 : this.leases) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("primary_term");
        generator.write(this.primaryTerm);
        generator.writeKey("version");
        generator.write(this.version);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupShardRetentionLeasesDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::leases, JsonpDeserializer.arrayDeserializer(ShardLease._DESERIALIZER), "leases");
        op.add(Builder::primaryTerm, JsonpDeserializer.longDeserializer(), "primary_term");
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.leases.hashCode();
        result = 31 * result + Long.hashCode(this.primaryTerm);
        result = 31 * result + Long.hashCode(this.version);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardRetentionLeases other = (ShardRetentionLeases)o;
        return this.leases.equals(other.leases) && this.primaryTerm == other.primaryTerm && this.version == other.version;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ShardRetentionLeases> {
        private List<ShardLease> leases;
        private Long primaryTerm;
        private Long version;

        public Builder() {
        }

        private Builder(ShardRetentionLeases o) {
            this.leases = Builder._listCopy(o.leases);
            this.primaryTerm = o.primaryTerm;
            this.version = o.version;
        }

        private Builder(Builder o) {
            this.leases = Builder._listCopy(o.leases);
            this.primaryTerm = o.primaryTerm;
            this.version = o.version;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder leases(List<ShardLease> list) {
            this.leases = Builder._listAddAll(this.leases, list);
            return this;
        }

        @Nonnull
        public final Builder leases(ShardLease value, ShardLease ... values) {
            this.leases = Builder._listAdd(this.leases, value, values);
            return this;
        }

        @Nonnull
        public final Builder leases(Function<ShardLease.Builder, ObjectBuilder<ShardLease>> fn) {
            return this.leases(fn.apply(new ShardLease.Builder()).build(), new ShardLease[0]);
        }

        @Nonnull
        public final Builder primaryTerm(long value) {
            this.primaryTerm = value;
            return this;
        }

        @Nonnull
        public final Builder version(long value) {
            this.version = value;
            return this;
        }

        @Override
        @Nonnull
        public ShardRetentionLeases build() {
            this._checkSingleUse();
            return new ShardRetentionLeases(this);
        }
    }
}

