/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ism;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.ism.Policy;
import org.opensearch.client.opensearch.ism.PutPoliciesResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public final class PutPoliciesRequest
extends RequestBase
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, PutPoliciesRequest> {
    @Nullable
    private final Number ifPrimaryTerm;
    @Nullable
    private final Long ifSeqNo;
    @Nullable
    private final Policy policy;
    @Nonnull
    private final String policyId;
    public static final JsonpDeserializer<PutPoliciesRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutPoliciesRequest::setupPutPoliciesRequestDeserializer);
    public static final Endpoint<PutPoliciesRequest, PutPoliciesResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutPoliciesRequest, PutPoliciesResponse>(request -> "PUT", request -> "/_plugins/_ism/policies", request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutPoliciesResponse._DESERIALIZER);

    private PutPoliciesRequest(Builder builder) {
        super(builder);
        this.ifPrimaryTerm = builder.ifPrimaryTerm;
        this.ifSeqNo = builder.ifSeqNo;
        this.policy = builder.policy;
        this.policyId = ApiTypeHelper.requireNonNull(builder.policyId, this, "policyId");
    }

    public static PutPoliciesRequest of(Function<Builder, ObjectBuilder<PutPoliciesRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Number ifPrimaryTerm() {
        return this.ifPrimaryTerm;
    }

    @Nullable
    public final Long ifSeqNo() {
        return this.ifSeqNo;
    }

    @Nullable
    public final Policy policy() {
        return this.policy;
    }

    @Nonnull
    public final String policyId() {
        return this.policyId;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.policy != null) {
            generator.writeKey("policy");
            this.policy.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupPutPoliciesRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::policy, Policy._DESERIALIZER, "policy");
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (this.ifPrimaryTerm != null) {
            params.put("if_primary_term", String.valueOf(this.ifPrimaryTerm));
        }
        if (this.ifSeqNo != null) {
            params.put("if_seq_no", String.valueOf(this.ifSeqNo));
        }
        params.put("policyID", this.policyId);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.ifPrimaryTerm);
        result = 31 * result + Objects.hashCode(this.ifSeqNo);
        result = 31 * result + Objects.hashCode(this.policy);
        result = 31 * result + this.policyId.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PutPoliciesRequest other = (PutPoliciesRequest)o;
        return Objects.equals(this.ifPrimaryTerm, other.ifPrimaryTerm) && Objects.equals(this.ifSeqNo, other.ifSeqNo) && Objects.equals(this.policy, other.policy) && this.policyId.equals(other.policyId);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, PutPoliciesRequest> {
        @Nullable
        private Number ifPrimaryTerm;
        @Nullable
        private Long ifSeqNo;
        @Nullable
        private Policy policy;
        private String policyId;

        public Builder() {
        }

        private Builder(PutPoliciesRequest o) {
            super(o);
            this.ifPrimaryTerm = o.ifPrimaryTerm;
            this.ifSeqNo = o.ifSeqNo;
            this.policy = o.policy;
            this.policyId = o.policyId;
        }

        private Builder(Builder o) {
            super(o);
            this.ifPrimaryTerm = o.ifPrimaryTerm;
            this.ifSeqNo = o.ifSeqNo;
            this.policy = o.policy;
            this.policyId = o.policyId;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder ifPrimaryTerm(@Nullable Number value) {
            this.ifPrimaryTerm = value;
            return this;
        }

        @Nonnull
        public final Builder ifSeqNo(@Nullable Long value) {
            this.ifSeqNo = value;
            return this;
        }

        @Nonnull
        public final Builder policy(@Nullable Policy value) {
            this.policy = value;
            return this;
        }

        @Nonnull
        public final Builder policy(Function<Policy.Builder, ObjectBuilder<Policy>> fn) {
            return this.policy(fn.apply(new Policy.Builder()).build());
        }

        @Nonnull
        public final Builder policyId(String value) {
            this.policyId = value;
            return this;
        }

        @Override
        @Nonnull
        public PutPoliciesRequest build() {
            this._checkSingleUse();
            return new PutPoliciesRequest(this);
        }
    }
}

