/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ml;

import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.ml.LoadModelResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

public final class LoadModelRequest
extends RequestBase
implements ToCopyableBuilder<Builder, LoadModelRequest> {
    @Nonnull
    private final String modelId;
    public static final Endpoint<LoadModelRequest, LoadModelResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<LoadModelRequest, LoadModelResponse>(request -> "POST", request -> {
        StringBuilder buf = new StringBuilder();
        buf.append("/_plugins/_ml/models/");
        SimpleEndpoint.pathEncode(request.modelId, buf);
        buf.append("/_load");
        return buf.toString();
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), false, LoadModelResponse._DESERIALIZER);

    private LoadModelRequest(Builder builder) {
        super(builder);
        this.modelId = ApiTypeHelper.requireNonNull(builder.modelId, this, "modelId");
    }

    public static LoadModelRequest of(Function<Builder, ObjectBuilder<LoadModelRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final String modelId() {
        return this.modelId;
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.modelId.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoadModelRequest other = (LoadModelRequest)o;
        return this.modelId.equals(other.modelId);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, LoadModelRequest> {
        private String modelId;

        public Builder() {
        }

        private Builder(LoadModelRequest o) {
            super(o);
            this.modelId = o.modelId;
        }

        private Builder(Builder o) {
            super(o);
            this.modelId = o.modelId;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder modelId(String value) {
            this.modelId = value;
            return this;
        }

        @Override
        @Nonnull
        public LoadModelRequest build() {
            this._checkSingleUse();
            return new LoadModelRequest(this);
        }
    }
}

