/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.crt;

import java.net.URI;
import java.time.Duration;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.http.HttpClientConnectionManager;
import software.amazon.awssdk.crt.http.HttpClientConnectionManagerOptions;
import software.amazon.awssdk.crt.http.HttpMonitoringOptions;
import software.amazon.awssdk.crt.http.HttpProxyOptions;
import software.amazon.awssdk.crt.io.ClientBootstrap;
import software.amazon.awssdk.crt.io.SocketOptions;
import software.amazon.awssdk.crt.io.TlsContext;
import software.amazon.awssdk.crt.io.TlsContextOptions;
import software.amazon.awssdk.crtcore.CrtConfigurationUtils;
import software.amazon.awssdk.crtcore.CrtConnectionHealthConfiguration;
import software.amazon.awssdk.crtcore.CrtProxyConfiguration;
import software.amazon.awssdk.http.Protocol;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.crt.internal.AwsCrtClientBuilderBase;
import software.amazon.awssdk.http.crt.internal.AwsCrtConfigurationUtils;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.FunctionalUtils;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.uri.SdkUri;

@SdkProtectedApi
abstract class AwsCrtHttpClientBase
implements SdkAutoCloseable {
    private static final software.amazon.awssdk.utils.Logger log = software.amazon.awssdk.utils.Logger.loggerFor(AwsCrtHttpClientBase.class);
    private static final String AWS_COMMON_RUNTIME = "AwsCommonRuntime";
    private static final long DEFAULT_STREAM_WINDOW_SIZE = 0x1000000L;
    protected final long readBufferSize;
    private final Map<URI, HttpClientConnectionManager> connectionPools = new ConcurrentHashMap<URI, HttpClientConnectionManager>();
    private final LinkedList<CrtResource> ownedSubResources = new LinkedList();
    private final ClientBootstrap bootstrap;
    private final SocketOptions socketOptions;
    private final TlsContext tlsContext;
    private final HttpProxyOptions proxyOptions;
    private final HttpMonitoringOptions monitoringOptions;
    private final long maxConnectionIdleInMilliseconds;
    private final int maxConnectionsPerEndpoint;
    private final long connectionAcquisitionTimeout;
    private boolean isClosed = false;

    AwsCrtHttpClientBase(AwsCrtClientBuilderBase builder, AttributeMap config) {
        if (config.get((AttributeMap.Key)SdkHttpConfigurationOption.PROTOCOL) == Protocol.HTTP2) {
            throw new UnsupportedOperationException("HTTP/2 is not supported in AwsCrtHttpClient yet. Use NettyNioAsyncHttpClient instead.");
        }
        try (ClientBootstrap clientBootstrap = new ClientBootstrap(null, null);
             SocketOptions clientSocketOptions = AwsCrtConfigurationUtils.buildSocketOptions(builder.getTcpKeepAliveConfiguration(), (Duration)config.get((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_TIMEOUT));
             TlsContextOptions clientTlsContextOptions = TlsContextOptions.createDefaultClient().withCipherPreference(AwsCrtConfigurationUtils.resolveCipherPreference(builder.getPostQuantumTlsEnabled())).withVerifyPeer((Boolean)config.get((AttributeMap.Key)SdkHttpConfigurationOption.TRUST_ALL_CERTIFICATES) == false);
             TlsContext clientTlsContext = new TlsContext(clientTlsContextOptions);){
            this.bootstrap = this.registerOwnedResource(clientBootstrap);
            this.socketOptions = this.registerOwnedResource(clientSocketOptions);
            this.tlsContext = this.registerOwnedResource(clientTlsContext);
            this.readBufferSize = builder.getReadBufferSizeInBytes() == null ? 0x1000000L : builder.getReadBufferSizeInBytes();
            this.maxConnectionsPerEndpoint = (Integer)config.get((AttributeMap.Key)SdkHttpConfigurationOption.MAX_CONNECTIONS);
            this.monitoringOptions = CrtConfigurationUtils.resolveHttpMonitoringOptions((CrtConnectionHealthConfiguration)builder.getConnectionHealthConfiguration()).orElse(null);
            this.maxConnectionIdleInMilliseconds = ((Duration)config.get((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_MAX_IDLE_TIMEOUT)).toMillis();
            this.connectionAcquisitionTimeout = ((Duration)config.get((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_ACQUIRE_TIMEOUT)).toMillis();
            this.proxyOptions = CrtConfigurationUtils.resolveProxy((CrtProxyConfiguration)builder.getProxyConfiguration(), (TlsContext)this.tlsContext).orElse(null);
        }
    }

    private <T extends CrtResource> T registerOwnedResource(T subresource) {
        if (subresource != null) {
            subresource.addRef();
            this.ownedSubResources.push(subresource);
        }
        return subresource;
    }

    String clientName() {
        return AWS_COMMON_RUNTIME;
    }

    private HttpClientConnectionManager createConnectionPool(URI uri) {
        log.debug(() -> "Creating ConnectionPool for: URI:" + uri + ", MaxConns: " + this.maxConnectionsPerEndpoint);
        HttpClientConnectionManagerOptions options = new HttpClientConnectionManagerOptions().withClientBootstrap(this.bootstrap).withSocketOptions(this.socketOptions).withTlsContext(this.tlsContext).withUri(uri).withWindowSize(this.readBufferSize).withMaxConnections(this.maxConnectionsPerEndpoint).withManualWindowManagement(true).withProxyOptions(this.proxyOptions).withMonitoringOptions(this.monitoringOptions).withMaxConnectionIdleInMilliseconds(this.maxConnectionIdleInMilliseconds).withConnectionAcquisitionTimeoutInMilliseconds(this.connectionAcquisitionTimeout);
        return HttpClientConnectionManager.create((HttpClientConnectionManagerOptions)options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HttpClientConnectionManager getOrCreateConnectionPool(URI uri) {
        AwsCrtHttpClientBase awsCrtHttpClientBase = this;
        synchronized (awsCrtHttpClientBase) {
            if (this.isClosed) {
                throw new IllegalStateException("Client is closed. No more requests can be made with this client.");
            }
            HttpClientConnectionManager connPool = this.connectionPools.computeIfAbsent(uri, this::createConnectionPool);
            connPool.addRef();
            return connPool;
        }
    }

    URI poolKey(SdkHttpRequest sdkRequest) {
        return (URI)FunctionalUtils.invokeSafely(() -> SdkUri.getInstance().newUri(sdkRequest.protocol(), null, sdkRequest.host(), sdkRequest.port(), null, null, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        AwsCrtHttpClientBase awsCrtHttpClientBase = this;
        synchronized (awsCrtHttpClientBase) {
            if (this.isClosed) {
                return;
            }
            this.connectionPools.values().forEach(pool -> IoUtils.closeQuietly((AutoCloseable)pool, (Logger)log.logger()));
            this.ownedSubResources.forEach(r -> IoUtils.closeQuietly((AutoCloseable)r, (Logger)log.logger()));
            this.ownedSubResources.clear();
            this.isClosed = true;
        }
    }
}

