/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.LineConfigurable;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.CreoleMode;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.url.Url;

public abstract class EntityImageStateCommon
extends AbstractEntityImage {
    protected final TextBlock title;
    protected final Url url;
    protected final LineConfigurable lineConfig;

    public EntityImageStateCommon(Entity entity) {
        super(entity);
        this.lineConfig = entity;
        FontConfiguration titleFontConfiguration = EntityImageStateCommon.getStyleStateTitle(entity, this.getSkinParam()).getFontConfiguration(this.getSkinParam().getIHtmlColorSet(), entity.getColors());
        HorizontalAlignment horizontalAlignment = EntityImageStateCommon.getStyleState(entity, this.getSkinParam()).getHorizontalAlignment();
        this.title = entity.getDisplay().create8(titleFontConfiguration, horizontalAlignment, this.getSkinParam(), CreoleMode.FULL, this.getStyleState().wrapWidth());
        this.url = entity.getUrl99();
    }

    public static Style getStyleStateTitle(Entity group, ISkinParam skinParam) {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.stateDiagram, SName.state, SName.title).withTOBECHANGED(group.getStereotype()).getMergedStyle(skinParam.getCurrentStyleBuilder());
    }

    public static Style getStyleStateHeader(Entity group, ISkinParam skinParam) {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.stateDiagram, SName.state, SName.header).withTOBECHANGED(group.getStereotype()).getMergedStyle(skinParam.getCurrentStyleBuilder());
    }

    public static Style getStyleState(Entity group, ISkinParam skinParam) {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.stateDiagram, SName.state).withTOBECHANGED(group.getStereotype()).getMergedStyle(skinParam.getCurrentStyleBuilder());
    }

    public static Style getStyleStateBody(Entity group, ISkinParam skinParam) {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.stateDiagram, SName.stateBody).withTOBECHANGED(group.getStereotype()).getMergedStyle(skinParam.getCurrentStyleBuilder());
    }

    protected final Style getStyleState() {
        return EntityImageStateCommon.getStyleState(this.getEntity(), this.getSkinParam());
    }

    protected final Style getStyleStateHeader() {
        return EntityImageStateCommon.getStyleStateHeader(this.getEntity(), this.getSkinParam());
    }

    @Override
    public final ShapeType getShapeType() {
        return ShapeType.ROUND_RECTANGLE;
    }

    protected final URectangle getShape(XDimension2D dimTotal) {
        double corner = this.getStyleState().value(PName.RoundCorner).asDouble();
        double deltaShadow = this.getStyleState().getShadowing();
        URectangle rect = URectangle.build(dimTotal).rounded(corner);
        rect.setDeltaShadow(deltaShadow);
        return rect;
    }

    protected final UGraphic applyColor(UGraphic ug) {
        HColor border = this.lineConfig.getColors().getColor(ColorType.LINE);
        if (border == null) {
            border = this.getStyleState().value(PName.LineColor).asColor(this.getSkinParam().getIHtmlColorSet());
        }
        ug = ug.apply(border);
        HColor backcolor = this.lineConfig.getColors().getColor(ColorType.BACK);
        if (backcolor == null) {
            backcolor = this.getStyleState().value(PName.BackGroundColor).asColor(this.getSkinParam().getIHtmlColorSet());
        }
        ug = ug.apply(backcolor.bg());
        return ug;
    }
}

