from typing import Tuple

from .. import Provider as PersonProvider


class Provider(PersonProvider):
    formats_female: Tuple[str, ...] = ("{{first_name_female}} {{last_name}}",)

    formats_male: Tuple[str, ...] = ("{{first_name_male}} {{last_name}}",)

    formats = formats_male + formats_female

    # Translated from: https://studentsoftheworld.info/penpals/stats_fr.php?Pays=ALG
    # Last checked: 2025-09-28
    first_names_female: Tuple[str, ...] = (
        "آية",
        "أماني",
        "أمل",
        "أمينة",
        "أميرة",
        "أناييس",
        "أنيسة",
        "أسماء",
        "إكرام",
        "إيمان",
        "إيناس",
        "بشرى",
        "تينهينان",
        "حياة",
        "خديجة",
        "داليا",
        "دنيا",
        "رانية",
        "رشا",
        "روز",
        "ريم",
        "ريما",
        "زينة",
        "زينب",
        "سارة",
        "سعاد",
        "سرين",
        "سلمى",
        "سليمة",
        "سميرة",
        "سومية",
        "سيليا",
        "سيلين",
        "شيراز",
        "صبرينة",
        "صفية",
        "صوفيا",
        "فاطمة",
        "فرح",
        "فريال",
        "فوزية",
        "فلة",
        "كاتيا",
        "كاهينة",
        "ليديا",
        "ليزا",
        "ليلى",
        "ليليا",
        "ليندة",
        "لينا",
        "ماريا",
        "مايا",
        "ملاك",
        "مروة",
        "مريم",
        "مزرية",
        "مينة",
        "ميرا",
        "ميليسا",
        "نادية",
        "نسرين",
        "نجمة",
        "نريمان",
        "نوال",
        "نهاد",
        "نور",
        "هاجر",
        "هانية",
        "هدى",
        "هناء",
        "وفاء",
        "ياسمين",
        "ياسمينة",
        "يسرى",
    )

    # Translated from: https://studentsoftheworld.info/penpals/stats_fr.php?Pays=ALG
    # Last checked: 2025-09-28
    first_names_male: Tuple[str, ...] = (
        "آدم",
        "أسامة",
        "أحمد",
        "أرزقي",
        "أكرم",
        "أمين",
        "أمير",
        "أنيس",
        "أيمن",
        "أيوب",
        "إبراهيم",
        "إلياس",
        "عبد الرحمن",
        "عبد الرؤوف",
        "عبد القادر",
        "علاء الدين",
        "عادل",
        "علي",
        "عمر",
        "فاتح",
        "فارس",
        "فاروق",
        "فريد",
        "فرحات",
        "فضيل",
        "غِلاس",
        "قادة",
        "خالد",
        "خليل",
        "رابح",
        "رضا",
        "رشدي",
        "رشيد",
        "رمزي",
        "رياض",
        "زكريا",
        "سعد",
        "سعيد",
        "سامي",
        "سمير",
        "سفيان",
        "سليم",
        "صالح",
        "شعبان",
        "شريف",
        "طه",
        "علي",
        "علاء الدين",
        "غِلاس",
        "قادة",
        "لطفي",
        "لمين",
        "مالك",
        "ماسِينيسا",
        "مراد",
        "محند",
        "محمد",
        "مصطفى",
        "منير",
        "مهدي",
        "مولود",
        "موسى",
        "ناصر",
        "ناظم",
        "نادر",
        "نسيم",
        "وليد",
        "وسيم",
        "وناس",
        "ياسر",
        "ياسين",
        "يانيس",
        "يحيى",
        "يوسف",
        "يونس",
        "يوبا",
    )

    first_names = first_names_male + first_names_female

    # Translated from: https://fr.geneawiki.com/wiki/Noms_de_famille_alg%C3%A9riens
    # Last checked: 2025-09-28
    last_names: Tuple[str, ...] = (
        "أعراب",
        "إبراهيمي",
        "إخلف",
        "إسماعيل",
        "باشا",
        "باي",
        "بحري",
        "بختي",
        "بخوش",
        "بغدادي",
        "بركان",
        "بركاني",
        "بلبشير",
        "بلحاج",
        "بلخير",
        "بلخيري",
        "بلعربي",
        "بلعيد",
        "بلعيدي",
        "بلقادي",
        "بلقاسم",
        "بلقاسمي",
        "بن أحمد",
        "بن زيان",
        "بن سالم",
        "بن سعيد",
        "بن سليمان",
        "بن شيخ",
        "بن صالح",
        "بن عامر",
        "بن عبد الله",
        "بن علي",
        "بن عمار",
        "بن عمارة",
        "بن عودة",
        "بن عيسى",
        "بن موسى",
        "بن يحيى",
        "بن يمينة",
        "بن يوسف",
        "بو عافية",
        "بو عبد الله",
        "بوبكر",
        "بوتالب",
        "بوجمعة",
        "بوخاتم",
        "بوخاري",
        "بوخلفة",
        "بودراع",
        "بوزيان",
        "بوزيد",
        "بوزيدي",
        "بوسعيد",
        "بوشامة",
        "بوشارب",
        "بوعزيز",
        "بوعلام",
        "بوعلي",
        "بومدين",
        "بومعزة",
        "بوناب",
        "تابت",
        "تومي",
        "تواتي",
        "جبار",
        "جلال",
        "جلولي",
        "جودي",
        "داود",
        "داوودي",
        "دحمان",
        "دحماني",
        "دراجـي",
        "دربال",
        "دركاوي",
        "درويش",
        "ديب",
        "دياف",
        "ديف",
        "رابحي",
        "رحال",
        "رحمون",
        "رحماني",
        "رحموني",
        "ربيعة",
        "رشدي",
        "رزّيق",
        "رمضاني",
        "زايدي",
        "زاوي",
        "زروال",
        "زرّوقي",
        "زواوي",
        "زيان",
        "زياني",
        "زيتوني",
        "زيدان",
        "ساسي",
        "سالم",
        "سالمي",
        "سعد",
        "سعدي",
        "سعودي",
        "سعيد",
        "سعيداني",
        "سعيدي",
        "سلامي",
        "سلطاني",
        "سليماني",
        "سهلي",
        "سوداني",
        "سياح",
        "شايب",
        "شاوي",
        "شريف",
        "شريفي",
        "شرقي",
        "شعبان",
        "شعيباني",
        "شيخ",
        "صالح",
        "صالحي",
        "صحراوي",
        "صدِّيقي",
        "طالب",
        "طالبي",
        "طايبي",
        "طحراوي",
        "طهري",
        "طويل",
        "عثماني",
        "فارس",
        "فرحات",
        "فلاح",
        "فيلالي",
        "قاسم",
        "قاسمي",
        "قاسي",
        "قبائلي",
        "قدور",
        "قدوري",
        "قرفي",
        "قريشي",
        "قندوز",
        "قويدري",
        "لحمر",
        "لخضر",
        "لعربي",
        "لعريبي",
        "لعمري",
        "لوسيف",
        "لونيس",
        "ماحي",
        "ماعوش",
        "مالك",
        "مالكي",
        "مباركي",
        "مخلوف",
        "مخلوفي",
        "مداح",
        "مداني",
        "مداهد",
        "مرابط",
        "مراح",
        "مرزوق",
        "مرزوقي",
        "مرسلي",
        "مزيان",
        "مزياني",
        "مسعودي",
        "مشري",
        "مصباح",
        "مصطفاوي",
        "مفتاح",
        "مقدم",
        "مقران",
        "مقراني",
        "محمدي",
        "محمودي",
        "مختاري",
        "معزوز",
        "معزوزي",
        "ميلودي",
        "ميموني",
        "ميهوبي",
        "مولاي",
        "موساوي",
        "موسى",
        "نايلي",
        "ناصر",
        "نجار",
        "نصري",
        "نوار",
        "نوري",
        "نوي",
        "هاشمي",
        "هني",
        "هواري",
        "يحبَوي",
        "يحيى",
        "يوسفي",
    )
