/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.bcel.classfile;

import java.io.DataInput;
import java.io.IOException;
import org.apache.tomcat.util.bcel.Const;
import org.apache.tomcat.util.bcel.classfile.ClassFormatException;
import org.apache.tomcat.util.bcel.classfile.Constant;
import org.apache.tomcat.util.bcel.classfile.ConstantInteger;
import org.apache.tomcat.util.bcel.classfile.ConstantUtf8;

public class ConstantPool {
    private final Constant[] constantPool;

    ConstantPool(DataInput dataInput) throws IOException, ClassFormatException {
        int n = dataInput.readUnsignedShort();
        this.constantPool = new Constant[n];
        for (int i = 1; i < n; ++i) {
            byte by;
            this.constantPool[i] = Constant.readConstant(dataInput);
            if (this.constantPool[i] == null || (by = this.constantPool[i].getTag()) != 6 && by != 5) continue;
            ++i;
        }
    }

    public <T extends Constant> T getConstant(int n) throws ClassFormatException {
        return (T)this.getConstant(n, Constant.class);
    }

    public <T extends Constant> T getConstant(int n, byte by) throws ClassFormatException {
        T t = this.getConstant(n);
        if (((Constant)t).getTag() != by) {
            throw new ClassFormatException("Expected class '" + Const.getConstantName(by) + "' at index " + n + " and got " + String.valueOf(t));
        }
        return t;
    }

    public <T extends Constant> T getConstant(int n, Class<T> clazz) throws ClassFormatException {
        Constant constant;
        if (n >= this.constantPool.length || n < 1) {
            throw new ClassFormatException("Invalid constant pool reference using index: " + n + ". Constant pool size is: " + this.constantPool.length);
        }
        if (this.constantPool[n] != null && !clazz.isAssignableFrom(this.constantPool[n].getClass())) {
            throw new ClassFormatException("Invalid constant pool reference at index: " + n + ". Expected " + String.valueOf(clazz) + " but was " + String.valueOf(this.constantPool[n].getClass()));
        }
        if (n > 1 && (constant = this.constantPool[n - 1]) != null && (constant.getTag() == 6 || constant.getTag() == 5)) {
            throw new ClassFormatException("Constant pool at index " + n + " is invalid. The index is unused due to the preceeding " + Const.getConstantName(constant.getTag()) + ".");
        }
        constant = (Constant)clazz.cast(this.constantPool[n]);
        if (constant == null) {
            throw new ClassFormatException("Constant pool at index " + n + " is null.");
        }
        return (T)constant;
    }

    public ConstantInteger getConstantInteger(int n) {
        return (ConstantInteger)this.getConstant(n, (byte)3);
    }

    public ConstantUtf8 getConstantUtf8(int n) throws ClassFormatException {
        return (ConstantUtf8)this.getConstant(n, (byte)1);
    }
}

